/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.gravity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerPlayNetworkHandlerMixin {
    @Unique
    private static double onPlayerMove_playerMovementY;
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    private double f_9756_;
    @Shadow
    private double f_9757_;
    @Shadow
    private double f_9758_;
    @Unique
    private double xx;
    @Unique
    private double yy;
    @Unique
    private double zz;

    @Shadow
    private static double m_143609_(double d) {
        return 0.0;
    }

    @Shadow
    private static double m_143653_(double d) {
        return 0.0;
    }

    @Redirect(method={"handleMovePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getY()D", ordinal=3))
    private double redirect_onPlayerMove_getY_3(ServerPlayer serverPlayerEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)serverPlayerEntity);
        if (gravityDirection == Direction.DOWN) {
            return serverPlayerEntity.m_20186_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)serverPlayerEntity.m_20182_(), (Direction)gravityDirection).f_82480_;
    }

    @WrapOperation(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;doCheckFallDamage(DDDZ)V")})
    private void jGravityAPI$doCheckFallDamage(ServerPlayer instance, double movementX, double movementY, double movementZ, boolean onGround, Operation<Void> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)instance);
        if (gravityDirection == Direction.DOWN) {
            original.call(new Object[]{instance, movementX, movementY, movementZ, onGround});
            return;
        }
        Vec3 movement = RotationUtil.vecWorldToPlayer(new Vec3(movementX, movementY, movementZ), gravityDirection);
        original.call(new Object[]{instance, movement.f_82479_, movement.f_82480_, movement.f_82481_, onGround});
    }

    @ModifyVariable(method={"handleMovePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;onGround()Z", ordinal=0), ordinal=0)
    private boolean modify_onPlayerMove_boolean_0(boolean value, ServerboundMovePlayerPacket packet) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_9743_);
        if (gravityDirection == Direction.DOWN) {
            return value;
        }
        onPlayerMove_playerMovementY = RotationUtil.vecWorldToPlayer((double)(ServerPlayNetworkHandlerMixin.m_143609_((double)packet.m_134129_((double)this.f_9743_.m_20185_())) - this.f_9756_), (double)(ServerPlayNetworkHandlerMixin.m_143653_((double)packet.m_134140_((double)this.f_9743_.m_20186_())) - this.f_9757_), (double)(ServerPlayNetworkHandlerMixin.m_143609_((double)packet.m_134146_((double)this.f_9743_.m_20189_())) - this.f_9758_), (Direction)gravityDirection).f_82480_;
        return onPlayerMove_playerMovementY > 0.0;
    }

    @ModifyVariable(method={"handleMovePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getX()D", ordinal=5), ordinal=10)
    private double modify_onPlayerMove_double_12(double value) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_9743_);
        if (gravityDirection == Direction.DOWN) {
            return value;
        }
        return onPlayerMove_playerMovementY;
    }

    @ModifyArg(method={"handleMovePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", ordinal=0), index=1)
    private Vec3 modify_onPlayerMove_move_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_9743_);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyArg(method={"handleMoveVehicle"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"), index=1)
    private Vec3 modify_onVehicleMove_move_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_9743_);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyArg(method={"noBlocksAround"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;expandTowards(DDD)Lnet/minecraft/world/phys/AABB;"), index=0)
    private double modify_onVehicleMove_move_0(double x) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_9743_);
        this.xx = x;
        Vec3 argVec = new Vec3(this.xx, this.yy, this.zz);
        argVec = RotationUtil.vecWorldToPlayer(argVec, gravityDirection);
        return argVec.f_82479_;
    }

    @ModifyArg(method={"noBlocksAround"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;expandTowards(DDD)Lnet/minecraft/world/phys/AABB;"), index=0)
    private double modify_onVehicleMove_move_1(double y) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_9743_);
        this.yy = y;
        Vec3 argVec = new Vec3(this.xx, this.yy, this.zz);
        argVec = RotationUtil.vecWorldToPlayer(argVec, gravityDirection);
        return argVec.f_82480_;
    }

    @ModifyArg(method={"noBlocksAround"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;expandTowards(DDD)Lnet/minecraft/world/phys/AABB;"), index=0)
    private double modify_onVehicleMove_move_2(double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_9743_);
        this.zz = z;
        Vec3 argVec = new Vec3(this.xx, this.yy, this.zz);
        argVec = RotationUtil.vecWorldToPlayer(argVec, gravityDirection);
        return argVec.f_82481_;
    }
}

