/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.gravity;

import java.util.function.Predicate;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WitherBoss.class})
public abstract class WitherEntityMixin {
    @Shadow
    public static Predicate<LivingEntity> f_31431_;

    @Redirect(method={"performRangedAttack(ILnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D"))
    private double redirect_shootSkullAt_getX_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20185_();
        }
        return target.m_20182_().m_82549_((Vec3)RotationUtil.vecPlayerToWorld((double)0.0, (double)((double)target.m_20192_() * 0.5), (double)0.0, (Direction)gravityDirection)).f_82479_;
    }

    @Redirect(method={"performRangedAttack(ILnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=0))
    private double redirect_shootSkullAt_getY_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20186_();
        }
        return target.m_20182_().m_82549_((Vec3)RotationUtil.vecPlayerToWorld((double)0.0, (double)((double)target.m_20192_() * 0.5), (double)0.0, (Direction)gravityDirection)).f_82480_ - (double)target.m_20192_() * 0.5;
    }

    @Redirect(method={"performRangedAttack(ILnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=0))
    private double redirect_shootSkullAt_getZ_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20189_();
        }
        return target.m_20182_().m_82549_((Vec3)RotationUtil.vecPlayerToWorld((double)0.0, (double)((double)target.m_20192_() * 0.5), (double)0.0, (Direction)gravityDirection)).f_82481_;
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getEyeY()D"))
    private double redirect_tickMovement_getEyeY_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20188_();
        }
        return entity.m_146892_().f_82480_;
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D"))
    private double redirect_tickMovement_getX_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20185_();
        }
        return entity.m_146892_().f_82479_;
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getZ()D", ordinal=0))
    private double redirect_tickMovement_getZ_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20189_();
        }
        return entity.m_146892_().f_82481_;
    }

    @Inject(at={@At(value="TAIL")}, method={"<clinit>"})
    private static void dont_attack_player_stands_in_creative(CallbackInfo ci) {
        Predicate<LivingEntity> oldSelector = f_31431_;
        f_31431_ = oldSelector.and(arg -> {
            LivingEntity maybeUser = JUtils.getUserIfStand(arg);
            if (maybeUser instanceof Player) {
                Player player = (Player)maybeUser;
                return !player.m_7500_() && !player.m_5833_();
            }
            if (maybeUser != arg) {
                return oldSelector.test(maybeUser);
            }
            return true;
        });
        WitherBoss.f_31432_.m_26888_(f_31431_);
    }
}

