/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin_logic;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EntityMixinLogic {
    public static void jcraft$updatePassengerPosition(Entity thisEntity, Entity passenger, Entity.MoveFunction positionUpdater, CallbackInfo info) {
        if (passenger instanceof StandEntity) {
            StandEntity stand = (StandEntity)passenger;
            if (stand.isFree() && !stand.isRemote()) {
                Vector3f freePos = stand.getFreePos();
                positionUpdater.m_20372_(passenger, (double)freePos.x(), (double)freePos.y(), (double)freePos.z());
                info.cancel();
                return;
            }
            double dist = stand.getDistanceOffset();
            float y = thisEntity.m_146908_() + stand.getRotationOffset();
            double heightOffset = stand.shouldOffsetHeight() ? Vec3.m_82498_((float)thisEntity.m_146909_(), (float)thisEntity.m_146908_()).f_82480_ : 0.0;
            Vec3 adjustedOffset = RotationUtil.vecPlayerToWorld((double)Mth.m_14089_((float)(y *= (float)Math.PI / 180)) * dist, passenger.m_6049_() + heightOffset, (double)Mth.m_14031_((float)y) * dist, GravityChangerAPI.getGravityDirection(thisEntity));
            positionUpdater.m_20372_(passenger, thisEntity.m_20185_() + adjustedOffset.f_82479_, thisEntity.m_20186_() + adjustedOffset.f_82480_, thisEntity.m_20189_() + adjustedOffset.f_82481_);
            info.cancel();
        }
    }

    public static void doNotPlayDesummonSoundWhenMovingWorld(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        StandEntity<?, ?> stand = JUtils.getStand(living);
        if (stand == null) {
            return;
        }
        stand.setPlayDesummonSound(false);
    }

    public static void inject_calculateBoundingBox(Entity entity, CallbackInfoReturnable<AABB> cir) {
        if (entity instanceof Projectile) {
            return;
        }
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB box = ((AABB)cir.getReturnValue()).m_82383_(entity.m_20182_().m_82548_());
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            box = box.m_82386_(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection).m_82383_(entity.m_20182_()));
    }

    public static void inject_calculateBoundsForPose(Entity entity, CallbackInfoReturnable<AABB> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB box = ((AABB)cir.getReturnValue()).m_82383_(entity.m_20182_().m_82548_());
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            box = box.m_82386_(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection).m_82383_(entity.m_20182_()));
    }

    public static void inject_getRotationVector(Entity entity, CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld((Vec3)cir.getReturnValue(), gravityDirection));
    }

    public static void inject_getVelocityAffectingPos(Entity entity, CallbackInfoReturnable<BlockPos> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)BlockPos.m_274446_((Position)entity.m_20182_().m_82549_(Vec3.m_82528_((Vec3i)gravityDirection.m_122436_()).m_82490_(0.5000001))));
    }

    public static void inject_getEyePos(Entity entity, CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(0.0, (double)entity.m_20192_(), 0.0, gravityDirection).m_82549_(entity.m_20182_()));
    }

    public static void inject_getCameraPosVec(Entity entity, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 vec3d = RotationUtil.vecPlayerToWorld(0.0, (double)entity.m_20192_(), 0.0, gravityDirection);
        double d = Mth.m_14139_((double)tickDelta, (double)entity.f_19854_, (double)entity.m_20185_()) + vec3d.f_82479_;
        double e = Mth.m_14139_((double)tickDelta, (double)entity.f_19855_, (double)entity.m_20186_()) + vec3d.f_82480_;
        double f = Mth.m_14139_((double)tickDelta, (double)entity.f_19856_, (double)entity.m_20189_()) + vec3d.f_82481_;
        cir.setReturnValue((Object)new Vec3(d, e, f));
    }

    public static void inject_getBrightnessAtFEyes(Entity entity, CallbackInfoReturnable<Float> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(entity.m_9236_().m_151577_(entity.m_146903_(), entity.m_146907_()) ? entity.m_9236_().m_220417_(BlockPos.m_274446_((Position)entity.m_146892_())) : 0.0f));
    }

    public static void inject_pushAwayFrom(Entity thisEntity, Entity entity, CallbackInfo ci) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(thisEntity);
        Direction otherGravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN && otherGravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        if (!(thisEntity.m_20365_(entity) || entity.f_19794_ || thisEntity.f_19794_)) {
            double g;
            Vec3 entityOffset = entity.m_20191_().m_82399_().m_82546_(thisEntity.m_20191_().m_82399_());
            Vec3 playerEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, gravityDirection);
            double dx = playerEntityOffset.f_82479_;
            double dz = playerEntityOffset.f_82481_;
            double f = Mth.m_14005_((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!thisEntity.m_20160_()) {
                    thisEntity.m_5997_(-dx, 0.0, -dz);
                }
            }
            Vec3 entityEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, otherGravityDirection);
            dx = entityEntityOffset.f_82479_;
            dz = entityEntityOffset.f_82481_;
            f = Mth.m_14005_((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!entity.m_20160_()) {
                    entity.m_5997_(dx, 0.0, dz);
                }
            }
        }
    }

    public static void redirect_adjustMovementForCollisions_adjustMovementForCollisions_0(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, ImmutableList.Builder<VoxelShape> shapeListBuilder, CallbackInfoReturnable<Vec3> cir) {
        EntityMixinLogic.redirect_adjustMovementForCollisions_adjustMovementForCollisions_0(entity, movement, entityBoundingBox, world, (List<VoxelShape>)shapeListBuilder.build(), cir);
    }

    public static void redirect_adjustMovementForCollisions_adjustMovementForCollisions_0(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions, CallbackInfoReturnable<Vec3> cir) {
        boolean isZLargerThanX;
        Direction gravityDirection;
        if (entity == null || (gravityDirection = GravityChangerAPI.getGravityDirection(entity)) == Direction.DOWN) {
            return;
        }
        Vec3 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        double playerMovementX = playerMovement.f_82479_;
        double playerMovementY = playerMovement.f_82480_;
        double playerMovementZ = playerMovement.f_82481_;
        Direction directionX = RotationUtil.dirPlayerToWorld(Direction.EAST, gravityDirection);
        Direction directionY = RotationUtil.dirPlayerToWorld(Direction.UP, gravityDirection);
        Direction directionZ = RotationUtil.dirPlayerToWorld(Direction.SOUTH, gravityDirection);
        if (playerMovementY != 0.0 && (playerMovementY = Shapes.m_193135_((Direction.Axis)directionY.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementY * (double)directionY.m_122421_().m_122540_())) * (double)directionY.m_122421_().m_122540_()) != 0.0) {
            entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(0.0, playerMovementY, 0.0, gravityDirection));
        }
        boolean bl = isZLargerThanX = Math.abs(playerMovementX) < Math.abs(playerMovementZ);
        if (isZLargerThanX && playerMovementZ != 0.0 && (playerMovementZ = Shapes.m_193135_((Direction.Axis)directionZ.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.m_122421_().m_122540_())) * (double)directionZ.m_122421_().m_122540_()) != 0.0) {
            entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(0.0, 0.0, playerMovementZ, gravityDirection));
        }
        if (playerMovementX != 0.0) {
            playerMovementX = Shapes.m_193135_((Direction.Axis)directionX.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementX * (double)directionX.m_122421_().m_122540_())) * (double)directionX.m_122421_().m_122540_();
            if (!isZLargerThanX && playerMovementX != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(playerMovementX, 0.0, 0.0, gravityDirection));
            }
        }
        if (!isZLargerThanX && playerMovementZ != 0.0) {
            playerMovementZ = Shapes.m_193135_((Direction.Axis)directionZ.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.m_122421_().m_122540_())) * (double)directionZ.m_122421_().m_122540_();
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(playerMovementX, playerMovementY, playerMovementZ, gravityDirection));
    }

    public static void inject_spawnSprintingParticles(Entity entity, RandomSource random, EntityDimensions dimensions, CallbackInfo ci) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 floorPos = entity.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(0.0, (double)0.2f, 0.0, gravityDirection));
        BlockPos blockPos = BlockPos.m_274446_((Position)floorPos);
        BlockState blockState = entity.m_9236_().m_8055_(blockPos);
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 particlePos = entity.m_20182_().m_82549_(RotationUtil.vecPlayerToWorld((random.m_188500_() - 0.5) * (double)dimensions.f_20377_, 0.1, (random.m_188500_() - 0.5) * (double)dimensions.f_20377_, gravityDirection));
            Vec3 playerVelocity = entity.m_20184_();
            Vec3 particleVelocity = RotationUtil.vecPlayerToWorld(playerVelocity.f_82479_ * -4.0, 1.5, playerVelocity.f_82481_ * -4.0, gravityDirection);
            entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
        }
    }
}

