/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin_logic;

import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.util.IJInputStateManagerHolder;
import net.arna.jcraft.common.util.InputStateManager;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ServerPlayerEntityMixinLogic {
    public static void inject_moveToWorld_sendPacket_1(ServerPlayer serverPlayer) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)serverPlayer);
        if (gravityDirection != GravityChangerAPI.getDefaultGravityDirection((Entity)serverPlayer) && JCraft.gravityConfig.resetGravityOnDimensionChange) {
            GravityChangerAPI.setDefaultGravityDirection((Entity)serverPlayer, Direction.DOWN, new RotationParameters().rotationTime(0));
        } else {
            GravityChangerAPI.setDefaultGravityDirection((Entity)serverPlayer, GravityChangerAPI.getDefaultGravityDirection((Entity)serverPlayer), new RotationParameters().rotationTime(0));
        }
    }

    public static void resummonStandAfterWorldMove(ServerPlayer serverPlayer, boolean hadStand, ServerLevel destination, CallbackInfoReturnable<Entity> cir) {
        if (!hadStand) {
            return;
        }
        StandEntity<?, ?> stand = JCraft.summon((Level)destination, (LivingEntity)serverPlayer);
        if (stand != null) {
            stand.setPlaySummonSound(false);
        }
    }

    public static void doNotPlayDesummonSoundWhenMovingWorld(ServerPlayer serverPlayer, ServerLevel destination, CallbackInfoReturnable<Entity> cir) {
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)serverPlayer);
        if (stand == null) {
            return;
        }
        stand.setPlayDesummonSound(false);
    }

    public static void copyInputStateManagerUponCopy(InputStateManager thisManager, ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        if (!alive) {
            return;
        }
        InputStateManager old = ((IJInputStateManagerHolder)oldPlayer).jcraft$getJInputStateManager();
        thisManager.copyFrom(old);
    }

    public static void jcraft$dropItem(ServerPlayer serverPlayer, ItemStack stack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<ItemEntity> cir) {
        if (!JUtils.canAct((LivingEntity)serverPlayer) && serverPlayer.m_6084_()) {
            cir.cancel();
        }
    }
}

