/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public abstract class ProjectileBossAbstract
extends AbstractHurtingProjectile {
    protected int timer;
    protected boolean fired;

    public ProjectileBossAbstract(EntityType<? extends ProjectileBossAbstract> type, Level world) {
        super(type, world);
    }

    public ProjectileBossAbstract(EntityType<? extends ProjectileBossAbstract> type, LivingEntity shooter, double accelX, double accelY, double accelZ, Level worldIn) {
        super(type, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected abstract float getDamage(LivingEntity var1, Entity var2);

    protected void m_5790_(EntityHitResult raytrace) {
        super.m_5790_(raytrace);
        if (!this.m_9236_().f_46443_ && this.fired) {
            Entity hit = raytrace.m_82443_();
            Entity shooter = this.m_19749_();
            if (shooter instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)shooter;
                boolean wasHit = hit.m_6469_(this.m_269291_().m_269299_((Entity)this, livingentity), this.getDamage(livingentity, hit));
                if (wasHit && hit.m_6084_()) {
                    this.m_19970_(livingentity, hit);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                boolean bl = hit.m_6469_(this.m_269291_().m_269425_(), 5.0f);
            }
        }
    }

    protected abstract void projTick();

    protected void particles(double targetx, double targety, double targetz) {
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            --this.timer;
            this.projTick();
        }
        Entity shooter = this.m_19749_();
        if (this.m_9236_().f_46443_ || (shooter == null || !shooter.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            this.superTick();
            HitResult raytraceresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_(raytraceresult);
            }
            this.m_20101_();
            Vec3 vector3d = this.m_20184_();
            double d0 = this.m_20185_() + vector3d.f_82479_;
            double d1 = this.m_20186_() + vector3d.f_82480_;
            double d2 = this.m_20189_() + vector3d.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            this.particles(d0, d1, d2);
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void superTick() {
        if (!this.m_9236_().f_46443_) {
            this.m_20115_(6, this.m_142038_());
        }
        this.m_6075_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Timer", this.timer);
        compound.m_128379_("Fired", this.fired);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.timer = compound.m_128451_("Timer");
        this.fired = compound.m_128471_("Fired");
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected boolean m_5931_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

