/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import javax.annotation.Nullable;
import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.registry.MYFEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class SwampMineEntity
extends Entity {
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.m_135353_(SwampMineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity bomber;

    public SwampMineEntity(EntityType<? extends SwampMineEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19850_ = true;
    }

    public SwampMineEntity(Level worldIn, double x, double y, double z, @Nullable LivingEntity igniter) {
        this((EntityType<? extends SwampMineEntity>)((EntityType)MYFEntities.SWAMP_MINE.get()), worldIn);
        this.m_6034_(x, y, z);
        double angle = worldIn.f_46441_.m_188500_() * Math.PI * 2.0;
        this.m_20334_(-Math.sin(angle) * 0.06, 0.05, -Math.cos(angle) * 0.06);
        this.setFuse(200);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.bomber = igniter;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        int fuse = this.getFuse();
        if (fuse > 10) {
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            if (this.m_20096_()) {
                this.setFuse(10);
                this.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.setFuse(--fuse);
            }
        } else {
            this.setFuse(--fuse);
        }
        if (fuse <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void explode() {
        this.m_9236_().m_254849_((Entity)(this.bomber != null ? this.bomber : this), this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), (float)MYFConfigValues.SWAMPJAW_EXPLOSION, Level.ExplosionInteraction.NONE);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FUSE, (Object)200);
    }

    public void setFuse(int fuse) {
        this.f_19804_.m_135381_(FUSE, (Object)fuse);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(FUSE);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128376_("Fuse", (short)this.getFuse());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setFuse(compound.m_128448_("Fuse"));
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.15f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

