/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lykrast.meetyourfight.config.MYFConfigValues;
import lykrast.meetyourfight.item.CustomTier;
import lykrast.meetyourfight.registry.MYFItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;

public class CocktailCutlass
extends SwordItem {
    private static final Tier TIER = new CustomTier(3, 3168, 8.0f, 3.0f, 14, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MYFItems.fortunesFavor.get()}));
    private static final List<Triple<MobEffect, Integer, Boolean>> EFFECTS = new ArrayList<Triple<MobEffect, Integer, Boolean>>();
    private Supplier<Boolean> hasLuck;

    public static void initEffects() {
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19596_, (Object)1200, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19598_, (Object)1200, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19600_, (Object)1200, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19605_, (Object)200, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19606_, (Object)1200, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19607_, (Object)1200, (Object)true));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19608_, (Object)1200, (Object)true));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19609_, (Object)1200, (Object)true));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19617_, (Object)1200, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19621_, (Object)1200, (Object)false));
    }

    public CocktailCutlass(Item.Properties builderIn, Supplier<Boolean> hasLuck) {
        super(TIER, 3, -2.4f, builderIn);
        this.hasLuck = hasLuck;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target != null && attacker instanceof Player) {
            float luck = ((Player)attacker).m_36336_();
            double chance = MYFConfigValues.COCKTAIL_CUTLASS_CHANCE;
            if (MYFConfigValues.COCKTAIL_CUTLASS_LUCK) {
                chance = luck >= 0.0f ? (1.0 + 0.5 * (double)luck) / (1.0 / MYFConfigValues.COCKTAIL_CUTLASS_CHANCE + 0.5 * (double)luck) : 1.0 / (1.0 / MYFConfigValues.COCKTAIL_CUTLASS_CHANCE - (double)luck);
            }
            int effectLevel = -1;
            if (attacker.m_9236_().m_213780_().m_188500_() <= chance) {
                effectLevel = 0;
                for (int i = 0; i < 2; ++i) {
                    chance *= 0.5;
                    if (!(attacker.m_9236_().m_213780_().m_188500_() <= chance)) break;
                    ++effectLevel;
                }
            }
            if (effectLevel >= 0) {
                Triple<MobEffect, Integer, Boolean> triple = EFFECTS.get(attacker.m_9236_().m_213780_().m_188503_(EFFECTS.size()));
                int duration = (Boolean)triple.getRight() != false ? (Integer)triple.getMiddle() * (1 + effectLevel) : (Integer)triple.getMiddle();
                int potency = (Boolean)triple.getRight() != false ? 0 : effectLevel;
                attacker.m_7292_(new MobEffectInstance((MobEffect)triple.getLeft(), duration, potency, false, false, true));
                attacker.m_9236_().m_5594_(null, attacker.m_20183_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".desc"), (Object[])new Object[]{MYFConfigValues.percent(MYFConfigValues.COCKTAIL_CUTLASS_CHANCE)}).m_130940_(ChatFormatting.GRAY));
        if (this.hasLuck.get().booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"item.meetyourfight.desc.luck").m_130940_(ChatFormatting.GRAY));
        }
    }
}

