/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.item.compat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lykrast.gunswithoutroses.item.GunItem;
import lykrast.gunswithoutroses.item.IBullet;
import lykrast.meetyourfight.config.MYFConfigValues;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;

public class CocktailShotgun
extends GunItem {
    private static final List<Triple<MobEffect, Integer, Boolean>> EFFECTS = new ArrayList<Triple<MobEffect, Integer, Boolean>>();
    private Supplier<Boolean> hasLuck;

    public static void initEffects() {
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19597_, (Object)400, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19613_, (Object)400, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19614_, (Object)400, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19615_, (Object)400, (Object)false));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19619_, (Object)400, (Object)true));
        EFFECTS.add((Triple<MobEffect, Integer, Boolean>)Triple.of((Object)MobEffects.f_19620_, (Object)100, (Object)false));
    }

    public CocktailShotgun(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability, Supplier<Boolean> hasLuck) {
        super(properties, bonusDamage, damageMultiplier, fireDelay, inaccuracy, enchantability);
        this.hasLuck = hasLuck;
    }

    protected void shoot(Level world, Player player, ItemStack gun, ItemStack ammo, IBullet bulletItem, boolean bulletFree) {
        super.shoot(world, player, gun, ammo, bulletItem, bulletFree);
        float luck = player.m_36336_();
        double chance = MYFConfigValues.COCKTAIL_SHOTGUN_CHANCE;
        if (MYFConfigValues.COCKTAIL_SHOTGUN_LUCK) {
            chance = luck >= 0.0f ? (1.0 + 0.5 * (double)luck) / (1.0 / MYFConfigValues.COCKTAIL_SHOTGUN_CHANCE + 0.5 * (double)luck) : 1.0 / (1.0 / MYFConfigValues.COCKTAIL_SHOTGUN_CHANCE - (double)luck);
        }
        int effectLevel = -1;
        if (world.m_213780_().m_188500_() <= chance) {
            effectLevel = 0;
            for (int i = 0; i < 2; ++i) {
                chance *= 0.5;
                if (!(world.m_213780_().m_188500_() <= chance)) break;
                ++effectLevel;
            }
        }
        if (effectLevel >= 0) {
            Triple<MobEffect, Integer, Boolean> triple = EFFECTS.get(world.m_213780_().m_188503_(EFFECTS.size()));
            int duration = (Boolean)triple.getRight() != false ? (Integer)triple.getMiddle() * (1 + effectLevel) : (Integer)triple.getMiddle();
            int potency = (Boolean)triple.getRight() != false ? 0 : effectLevel;
            ThrownPotion potionentity = new ThrownPotion(world, (LivingEntity)player);
            potionentity.m_37446_(PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), Collections.singleton(new MobEffectInstance((MobEffect)triple.getLeft(), duration, potency))));
            potionentity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -5.0f, (float)this.getProjectileSpeed(gun, (LivingEntity)player), 1.0f);
            world.m_7967_((Entity)potionentity);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f / (world.m_213780_().m_188501_() * 0.4f + 0.8f));
        }
    }

    protected void addExtraStatsTooltip(ItemStack stack, @Nullable Level world, List<Component> tooltip) {
        super.addExtraStatsTooltip(stack, world, tooltip);
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".desc"), (Object[])new Object[]{MYFConfigValues.percent(MYFConfigValues.COCKTAIL_SHOTGUN_CHANCE)}).m_130940_(ChatFormatting.GRAY));
        if (this.hasLuck.get().booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"item.meetyourfight.desc.luck").m_130940_(ChatFormatting.GRAY));
        }
    }
}

