/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.BellringerEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class BellringerModel
extends HumanoidModel<BellringerEntity> {
    public static final ModelLayerLocation MODEL = new ModelLayerLocation(MeetYourFight.rl("bellringer"), "main");
    public static final ModelLayerLocation MODEL_HEAD = new ModelLayerLocation(MeetYourFight.rl("bellringer"), "head");
    private final ModelPart bell;
    private final ModelPart rightSleeve;
    private final ModelPart leftSleeve;
    private final ModelPart jacket;

    public BellringerModel(ModelPart modelPart) {
        super(modelPart);
        this.f_102814_.f_104207_ = false;
        this.bell = modelPart.m_171324_("bell");
        this.rightSleeve = modelPart.m_171324_("right_sleeve");
        this.leftSleeve = modelPart.m_171324_("left_sleeve");
        this.jacket = modelPart.m_171324_("jacket");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deform) {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)deform, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation clothes = deform.m_171469_(0.25f);
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(26, 48).m_171488_(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f, clothes), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("bell", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171481_(-4.0f, 5.0f, 2.0f, 6.0f, 6.0f, 7.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deform), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, clothes), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, clothes), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
        partdefinition.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, clothes), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.bell, (Object)this.rightSleeve, (Object)this.leftSleeve, (Object)this.jacket));
    }

    public void setupAnim(BellringerEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_102811_.f_104203_ = -1.5707964f;
        if (this.f_102608_ > 0.0f) {
            float f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.f_102808_.f_104203_ - 0.7f) * 0.75f;
            this.f_102811_.f_104203_ -= f1 * 1.2f + f2;
        }
        this.bell.m_104315_(this.f_102811_);
        this.rightSleeve.m_104315_(this.f_102811_);
        this.leftSleeve.m_104315_(this.f_102812_);
        this.jacket.m_104315_(this.f_102810_);
    }
}

