/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.FortunaBombEntity;
import lykrast.meetyourfight.renderer.FortunaBombModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class FortunaBombRenderer
extends EntityRenderer<FortunaBombEntity> {
    private static final ResourceLocation TEXTURE = MeetYourFight.rl("textures/entity/fortuna_dice.png");
    private static final ResourceLocation TEXTURE_WARNING = MeetYourFight.rl("textures/entity/fortuna_dice_white.png");
    private final FortunaBombModel<FortunaBombEntity> model;

    public FortunaBombRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new FortunaBombModel(context.m_174023_(FortunaBombModel.MODEL));
    }

    protected int getBlockLightLevel(FortunaBombEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public void render(FortunaBombEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float f2;
        matrixStackIn.m_85836_();
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_());
        float f1 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        this.model.m_6973_(entityIn, 0.0f, 0.0f, 0.0f, f, f1);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(TEXTURE));
        matrixStackIn.m_85837_(0.0, 0.15, 0.0);
        matrixStackIn.m_85836_();
        int fuse = entityIn.getFuse();
        int overlay = OverlayTexture.f_118083_;
        if ((float)fuse - partialTicks + 1.0f < 10.0f) {
            f2 = 1.0f - ((float)fuse - partialTicks + 1.0f) / 10.0f;
            f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)1.0f);
            f2 *= f2;
            f2 *= f2;
            float scale = 1.0f + f2 * 2.0f;
            matrixStackIn.m_85841_(scale, scale, scale);
            if ((float)fuse - partialTicks + 1.0f < 5.0f) {
                overlay = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)1.0f), (int)10);
            }
        }
        f2 = (float)entityIn.f_19797_ + partialTicks;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_((float)(f2 * 0.1f)) * 180.0f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14089_((float)(f2 * 0.1f)) * 180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(f2 * 0.15f)) * 360.0f));
        this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        if ((float)fuse - partialTicks + 1.0f < 5.0f) {
            VertexConsumer warningvertex = bufferIn.m_6299_(this.model.m_103119_(TEXTURE_WARNING));
            float scale = 1.0f - ((float)fuse - partialTicks) / 5.0f;
            scale = Mth.m_14036_((float)scale, (float)0.0f, (float)1.0f);
            scale *= scale;
            scale *= scale;
            scale = (1.0f - scale) * 0.125f;
            this.model.m_6973_(entityIn, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            for (int i = 0; i < 4; ++i) {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(45.0f));
                matrixStackIn.m_85836_();
                matrixStackIn.m_85841_(64.0f, scale, scale);
                this.model.m_7695_(matrixStackIn, warningvertex, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.m_85849_();
            }
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(FortunaBombEntity entity) {
        return TEXTURE;
    }

    public boolean shouldRender(FortunaBombEntity entity, Frustum frustrum, double p_114171_, double p_114172_, double p_114173_) {
        return super.m_5523_((Entity)entity, frustrum, p_114171_, p_114172_, p_114173_) || entity.getFuse() < 7;
    }
}

