/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth;

import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.scalinghealth.capability.IDifficultyAffected;
import net.silentchaos512.scalinghealth.capability.IDifficultySource;
import net.silentchaos512.scalinghealth.capability.IPetData;
import net.silentchaos512.scalinghealth.capability.IPlayerData;
import net.silentchaos512.scalinghealth.command.ModCommands;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.scalinghealth.network.Network;
import net.silentchaos512.scalinghealth.objects.Registration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="scalinghealth")
public class ScalingHealth {
    public static final String MOD_ID = "scalinghealth";
    public static final String MOD_NAME = "Scaling Health";
    public static final Logger LOGGER = LogManager.getLogger((String)"Scaling Health");
    public static final Random RANDOM = new Random();

    public ScalingHealth() {
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        Registration.register(modbus);
        SHConfig.register();
        Network.init();
        modbus.addListener(this::registerCaps);
        modbus.addListener(this::reloadConfig);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommandsEvent);
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IDifficultyAffected.class);
        event.register(IDifficultySource.class);
        event.register(IPlayerData.class);
        event.register(IPetData.class);
    }

    private void registerCommandsEvent(RegisterCommandsEvent event) {
        ModCommands.registerAll(event);
    }

    private void reloadConfig(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            SHConfig.CLIENT.reload();
        }
    }

    public static ResourceLocation getId(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

