/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.capability;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.IDifficultySource;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;

public class DifficultySourceCapability
implements IDifficultySource,
ICapabilitySerializable<CompoundTag> {
    public static Capability<IDifficultySource> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDifficultySource>(){});
    public static ResourceLocation NAME = ScalingHealth.getId("difficulty_source");
    private static IDifficultySource overworldCap = null;
    private static final String NBT_DIFFICULTY = "Difficulty";
    private final LazyOptional<IDifficultySource> holder = LazyOptional.of(() -> this);
    private float difficulty;
    private boolean exempt = false;

    public static Optional<IDifficultySource> getOverworldCap() {
        return Optional.ofNullable(overworldCap);
    }

    public static void setOverworldCap(IDifficultySource source) {
        overworldCap = source;
    }

    @Override
    public float getDifficulty() {
        return this.exempt ? 0.0f : this.difficulty;
    }

    @Override
    public void setDifficulty(float value) {
        this.difficulty = (float)SHDifficulty.clamp(value);
    }

    @Override
    public void setExempt(boolean exempt) {
        this.exempt = exempt;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.holder);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_(NBT_DIFFICULTY, this.difficulty);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.difficulty = nbt.m_128457_(NBT_DIFFICULTY);
    }

    public static boolean canAttachTo(ICapabilityProvider obj) {
        try {
            if (obj.getCapability(INSTANCE).isPresent()) {
                return false;
            }
        }
        catch (NullPointerException ex) {
            ScalingHealth.LOGGER.error("Failed to get capabilities from {}", (Object)obj);
            return false;
        }
        return obj instanceof Player || obj instanceof ServerLevel && ((ServerLevel)obj).m_46472_().equals((Object)Level.f_46428_);
    }
}

