/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.IPetData;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;

public class PetHealthCapability
implements IPetData,
ICapabilitySerializable<CompoundTag> {
    public static Capability<IPetData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPetData>(){});
    public static ResourceLocation NAME = ScalingHealth.getId("pet_health");
    private static final String NBT_HEALTH = "SHPetBonusHealth";
    private final LazyOptional<IPetData> holder = LazyOptional.of(() -> this);
    private float bonusHealth;
    private boolean refreshed = false;

    @Override
    public void addHealth(double hp, TamableAnimal pet) {
        this.bonusHealth = (float)((double)this.bonusHealth + hp);
        ModifierHandler.setMaxHealth((LivingEntity)pet, this.bonusHealth, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public float getBonusHealth() {
        return this.bonusHealth;
    }

    @Override
    public void tick(TamableAnimal pet) {
        if (!this.refreshed && pet.f_19797_ > 2) {
            this.refreshed = true;
            ModifierHandler.setMaxHealth((LivingEntity)pet, this.getBonusHealth(), AttributeModifier.Operation.ADDITION);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.holder);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_(NBT_HEALTH, this.bonusHealth);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.bonusHealth = nbt.m_128457_(NBT_HEALTH);
    }

    public static boolean canAttachTo(ICapabilityProvider obj) {
        try {
            if (obj.getCapability(INSTANCE).isPresent()) {
                return false;
            }
        }
        catch (NullPointerException ex) {
            ScalingHealth.LOGGER.error("Failed to get capabilities from {}", (Object)obj);
            return false;
        }
        return obj instanceof TamableAnimal;
    }
}

