/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client.gui.difficulty;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.scalinghealth.client.ClientHandler;
import net.silentchaos512.scalinghealth.client.KeyManager;
import net.silentchaos512.scalinghealth.client.gui.difficulty.DifficultyMeterShow;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.mode.AreaDifficultyMode;
import net.silentchaos512.scalinghealth.utils.mode.AreaDifficultyModes;
import net.silentchaos512.utils.Anchor;

public class DifficultyMeter
extends Screen {
    public static final DifficultyMeter INSTANCE = new DifficultyMeter((Component)Component.m_237113_((String)""));
    private static final ResourceLocation TEXTURE = new ResourceLocation("scalinghealth", "textures/gui/hud.png");
    private int lastDifficultyDisplayed = -100;
    private int lastAreaDifficultyDisplayed = -100;
    private int lastUpdateTime = Integer.MIN_VALUE;
    private boolean keyDown = false;

    protected DifficultyMeter(Component title) {
        super(title);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null || !EnabledFeatures.difficultyEnabled() || event.phase == TickEvent.Phase.END) {
            return;
        }
        this.keyDown = KeyManager.TOGGLE_DIFF.m_90857_();
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (!EnabledFeatures.difficultyEnabled()) {
            return;
        }
        DifficultyMeterShow showMode = (DifficultyMeterShow)((Object)SHConfig.CLIENT.difficultyMeterShow.get());
        if (event.getOverlay() != VanillaGuiOverlay.DEBUG_TEXT.type() || showMode == DifficultyMeterShow.NEVER) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        double maxDifficulty = ClientHandler.maxDifficultyValue;
        if (maxDifficulty <= 0.0) {
            return;
        }
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        AreaDifficultyMode areaMode = ClientHandler.areaMode;
        int preClampAreaDifficulty = (int)ClientHandler.areaDifficulty;
        int areaDifficulty = Mth.m_14045_((int)preClampAreaDifficulty, (int)0, (int)((int)maxDifficulty));
        int difficulty = areaMode == AreaDifficultyModes.ServerWide.INSTANCE ? areaDifficulty : (int)ClientHandler.playerDifficulty;
        int timeSinceLastUpdate = ClientTicks.ticksInGame() - this.lastUpdateTime;
        if (difficulty != this.lastDifficultyDisplayed) {
            this.lastDifficultyDisplayed = difficulty;
            this.lastUpdateTime = ClientTicks.ticksInGame();
        }
        if (areaDifficulty < this.lastAreaDifficultyDisplayed - 10 || areaDifficulty > this.lastAreaDifficultyDisplayed + 10 && timeSinceLastUpdate > 1200) {
            this.lastAreaDifficultyDisplayed = areaDifficulty;
            this.lastUpdateTime = ClientTicks.ticksInGame();
        }
        int currentTime = ClientTicks.ticksInGame();
        if (showMode == DifficultyMeterShow.ALWAYS || this.keyDown || (double)(currentTime - this.lastUpdateTime) < 20.0 * (Double)SHConfig.CLIENT.difficultyMeterShowTime.get()) {
            GuiGraphics graphics = event.getGuiGraphics();
            Anchor anchor = (Anchor)SHConfig.CLIENT.difficultyMeterAnchor.get();
            int posX = anchor.getX(width, 66, 5) + (Integer)SHConfig.CLIENT.difficultyMeterOffsetX.get();
            int posY = anchor.getY(height, 14, 5) + (Integer)SHConfig.CLIENT.difficultyMeterOffsetY.get();
            this.blitWithColor(graphics, posX, posY, 190, 0, 66, 14, 0xFFFFFF);
            int barLength = (int)((double)(60 * areaDifficulty) / maxDifficulty);
            this.blitWithColor(graphics, posX + 3, posY + 5, 193, 19, barLength, 6, 0xFFFFFF);
            barLength = (int)((double)(60 * difficulty) / maxDifficulty);
            this.blitWithColor(graphics, posX + 3, posY + 3, 193, 17, barLength, 2, 0xFFFFFF);
            float textScale = ((Double)SHConfig.CLIENT.difficultyMeterTextScale.get()).floatValue();
            if (textScale > 0.0f) {
                PoseStack stack = graphics.m_280168_();
                stack.m_85836_();
                stack.m_85841_(textScale, textScale, 1.0f);
                graphics.drawString(mc.f_91062_, I18n.m_118938_((String)"misc.scalinghealth.difficultyMeterText", (Object[])new Object[0]), (float)posX / textScale + 4.0f, (float)posY / textScale - 9.0f, 0xFFFFFF, true);
                String str = String.format("%d", areaDifficulty);
                int strWidth = mc.f_91062_.m_92895_(str);
                graphics.drawString(mc.f_91062_, str, (float)posX / textScale + 104.0f - (float)strWidth, (float)posY / textScale - 9.0f, 0xAAAAAA, true);
                stack.m_85849_();
            }
        }
    }

    private void blitWithColor(GuiGraphics graphics, int x, int y, int textureX, int textureY, int width, int height, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.m_280246_(r, g, b, 1.0f);
        graphics.m_280218_(TEXTURE, x, y, textureX, textureY, width, height);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

