/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.scalinghealth.capability.IPlayerData;
import net.silentchaos512.scalinghealth.command.ModCommands;
import net.silentchaos512.scalinghealth.utils.config.SHItems;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;

public final class HealthCommand {
    private HealthCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"sh_health").requires(source -> source.m_6761_(2));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(HealthCommand::runGetHealth))).executes(context -> HealthCommand.getHealthSingle((CommandContext<CommandSourceStack>)context, (Player)((CommandSourceStack)context.getSource()).m_81375_())));
        builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(HealthCommand::runSetHealth))));
        builder.then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(HealthCommand::runAddHealth))));
        dispatcher.register(builder);
    }

    private static int runGetHealth(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            HealthCommand.getHealthSingle(context, (Player)player);
        }
        return 1;
    }

    private static int getHealthSingle(CommandContext<CommandSourceStack> context, Player player) {
        IPlayerData data = SHPlayers.getPlayerData(player);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ModCommands.playerNameText(player), true);
        MutableComponent actualValues = ModCommands.valueText(player.m_21223_(), player.m_21233_());
        MutableComponent actualText = HealthCommand.text("actual", actualValues).m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> actualText, true);
        int extraHearts = data.getHeartCrystals();
        String extraHealth = (extraHearts >= 0 ? "+" : "") + 2 * extraHearts;
        MutableComponent heartsValues = HealthCommand.text("heartCrystals.values", extraHearts / SHItems.heartCrystalIncreaseAmount(), extraHealth).m_130940_(ChatFormatting.WHITE);
        MutableComponent heartsText = HealthCommand.text("heartCrystals", heartsValues).m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> heartsText, true);
        return 1;
    }

    private static int runSetHealth(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            IPlayerData data = SHPlayers.getPlayerData((Player)player);
            int intendedExtraHearts = (amount - SHPlayers.startingHealth()) / 2;
            data.setHeartCrystals((Player)player, intendedExtraHearts);
        }
        return 1;
    }

    private static int runAddHealth(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            SHPlayers.getPlayerData((Player)player).addHeartCrystals((Player)player, amount);
        }
        return 1;
    }

    private static MutableComponent text(String key, Object ... args) {
        return Component.m_237110_((String)("command.scalinghealth.health." + key), (Object[])args);
    }
}

