/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.scalinghealth.capability.IPlayerData;
import net.silentchaos512.scalinghealth.command.ModCommands;
import net.silentchaos512.scalinghealth.utils.config.SHItems;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;

public final class PowerCommand {
    private PowerCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"sh_power").requires(source -> source.m_6761_(2));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(PowerCommand::runGet))).executes(context -> PowerCommand.runGetSingle((CommandContext<CommandSourceStack>)context, (Player)((CommandSourceStack)context.getSource()).m_81375_())));
        builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(PowerCommand::runSet))));
        builder.then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(PowerCommand::runAdd))));
        dispatcher.register(builder);
    }

    private static int runGet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            PowerCommand.runGetSingle(context, (Player)player);
        }
        return 1;
    }

    private static int runGetSingle(CommandContext<CommandSourceStack> context, Player player) {
        IPlayerData data = SHPlayers.getPlayerData(player);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ModCommands.playerNameText(player), true);
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        MutableComponent actualText = PowerCommand.text("actual", String.format("%.1f", attr.m_22135_())).m_6881_().m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PowerCommand.lambda$runGetSingle$3((Component)actualText), true);
        int crystals = data.getPowerCrystals();
        String extraPower = (crystals >= 0 ? "+" : "") + data.getAttackDamageModifier();
        MutableComponent crystalsValues = PowerCommand.text("powerCrystals.values", crystals, extraPower).m_6881_().m_130940_(ChatFormatting.WHITE);
        MutableComponent crystalsText = PowerCommand.text("powerCrystals", crystalsValues).m_6881_().m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PowerCommand.lambda$runGetSingle$4((Component)crystalsText), true);
        return 1;
    }

    private static int runSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            IPlayerData data = SHPlayers.getPlayerData((Player)player);
            int intendedCrystalCount = (int)((double)(amount - 1) / SHItems.powerCrystalIncreaseAmount());
            data.setPowerCrystalCount((Player)player, intendedCrystalCount);
        }
        return 1;
    }

    private static int runAdd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            IPlayerData data = SHPlayers.getPlayerData((Player)player);
            data.addPowerCrystals((Player)player, amount);
        }
        return 1;
    }

    private static Component text(String key, Object ... args) {
        return Component.m_237110_((String)("command.scalinghealth.power." + key), (Object[])args);
    }

    private static /* synthetic */ Component lambda$runGetSingle$4(Component crystalsText) {
        return crystalsText;
    }

    private static /* synthetic */ Component lambda$runGetSingle$3(Component actualText) {
        return actualText;
    }
}

