/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.scalinghealth.capability.IDifficultyAffected;
import net.silentchaos512.scalinghealth.utils.MobDifficultyHandler;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;

public final class SummonCommand {
    private static final SimpleCommandExceptionType SUMMON_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed"));

    private SummonCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"sh_summon").requires(source -> source.m_6761_(2));
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(source -> SummonCommand.summonEntity((CommandSourceStack)source.getSource(), ResourceArgument.m_246260_((CommandContext)source, (String)"entity").m_205785_().m_135782_(), -1, false, ((CommandSourceStack)source.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"difficulty", (ArgumentType)IntegerArgumentType.integer()).executes(source -> SummonCommand.summonEntity((CommandSourceStack)source.getSource(), ResourceArgument.m_246260_((CommandContext)source, (String)"entity").m_205785_().m_135782_(), IntegerArgumentType.getInteger((CommandContext)source, (String)"difficulty"), false, ((CommandSourceStack)source.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"forceBlight", (ArgumentType)BoolArgumentType.bool()).executes(source -> SummonCommand.summonEntity((CommandSourceStack)source.getSource(), ResourceArgument.m_246260_((CommandContext)source, (String)"entity").m_205785_().m_135782_(), IntegerArgumentType.getInteger((CommandContext)source, (String)"difficulty"), BoolArgumentType.getBool((CommandContext)source, (String)"forceBlight"), ((CommandSourceStack)source.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(source -> SummonCommand.summonEntity((CommandSourceStack)source.getSource(), ResourceArgument.m_246260_((CommandContext)source, (String)"entity").m_205785_().m_135782_(), IntegerArgumentType.getInteger((CommandContext)source, (String)"difficulty"), BoolArgumentType.getBool((CommandContext)source, (String)"forceBlight"), Vec3Argument.m_120844_((CommandContext)source, (String)"pos"), new CompoundTag(), true))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(source -> SummonCommand.summonEntity((CommandSourceStack)source.getSource(), ResourceArgument.m_246260_((CommandContext)source, (String)"entity").m_205785_().m_135782_(), IntegerArgumentType.getInteger((CommandContext)source, (String)"difficulty"), BoolArgumentType.getBool((CommandContext)source, (String)"forceBlight"), Vec3Argument.m_120844_((CommandContext)source, (String)"pos"), CompoundTagArgument.m_87660_((CommandContext)source, (String)"nbt"), false)))))));
        dispatcher.register(builder);
    }

    private static int summonEntity(CommandSourceStack source, ResourceLocation id, int difficulty, boolean forceBlight, Vec3 pos, CompoundTag tags, boolean randomizeProperties) throws CommandSyntaxException {
        CompoundTag nbt = tags.m_6426_();
        nbt.m_128359_("id", id.toString());
        ServerLevel world = source.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)nbt, (Level)world, e -> {
            e.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, e.m_146908_(), e.m_146909_());
            return !world.m_8847_(e) ? null : e;
        });
        if (entity == null) {
            throw SUMMON_FAILED.create();
        }
        if (randomizeProperties && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(entity.m_20183_()), MobSpawnType.COMMAND, null, null);
            if (difficulty > 0) {
                IDifficultyAffected affected = SHDifficulty.affected((ICapabilityProvider)entity);
                boolean blight = forceBlight || MobDifficultyHandler.shouldBecomeBlight(mob, difficulty);
                affected.forceDifficulty(difficulty);
                MobDifficultyHandler.setEntityProperties(mob, affected, blight);
                affected.setProcessed(true);
            }
        }
        source.m_288197_(() -> Component.m_237110_((String)"commands.summon.success", (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }
}

