/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.config;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.Lazy;

public class ColorList {
    private Lazy<List<Integer>> list;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> config;

    public ColorList(ForgeConfigSpec.Builder builder, String path, String comment, int ... defaults) {
        List defaultList = Arrays.stream(defaults).mapToObj(Color::format).collect(Collectors.toList());
        this.recalculate();
        this.config = builder.comment(comment).defineList(path, defaultList, o -> o instanceof String && Color.validate((String)((String)o)));
    }

    public void recalculate() {
        this.list = Lazy.of(() -> ImmutableList.copyOf((Collection)((List)this.config.get()).stream().map(Color::parseInt).collect(Collectors.toList())));
    }

    public List<Integer> get() {
        return (List)this.list.get();
    }
}

