/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.config;

import com.udojava.evalex.Expression;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;

public enum EvalVars {
    HEALTH("health", ctx -> Float.valueOf(ctx.player != null ? ctx.player.m_21223_() : 20.0f)),
    MAX_HEALTH("maxHealth", ctx -> Float.valueOf(ctx.player != null ? ctx.player.m_21233_() : 20.0f)),
    FOOD("food", ctx -> ctx.player != null ? ctx.player.m_36324_().m_38702_() : 0),
    PLAYER_DIFFICULTY("difficulty", ctx -> Float.valueOf(ctx.player == null ? 0.0f : SHDifficulty.source((ICapabilityProvider)ctx.player).getDifficulty())),
    MAX_DIFFICULTY("maxDifficulty", ctx -> SHDifficulty.maxValue()),
    AREA_DIFFICULTY("areaDifficulty", ctx -> SHDifficulty.areaDifficulty(ctx.world, ctx.pos, false)),
    AREA_PLAYER_COUNT("areaPlayerCount", ctx -> SHDifficulty.playersInRange((LevelAccessor)ctx.world, (Vec3i)ctx.pos, SHDifficulty.groupSearchRadius()).count());

    private final String name;
    private final Function<Context, ? extends Number> value;

    private EvalVars(String name, Function<Context, ? extends Number> value) {
        this.name = name;
        this.value = value;
    }

    public String varName() {
        return this.name;
    }

    public static double apply(Player player, Expression expression) {
        return EvalVars.apply(player.m_9236_(), player.m_20183_(), player, expression);
    }

    public static double apply(Level world, BlockPos pos, @Nullable Player player, Expression expression) {
        Context context = new Context(world, pos, player);
        for (EvalVars variable : EvalVars.values()) {
            expression.setVariable(variable.varName(), variable.value.apply(context).toString());
        }
        return expression.eval().doubleValue();
    }

    public static Expression dummyPopulate(Expression expression) {
        for (EvalVars var : EvalVars.values()) {
            expression.setVariable(var.varName(), "1");
        }
        return expression;
    }

    private static final class Context {
        private final Level world;
        private final BlockPos pos;
        private final Player player;

        private Context(Level world, BlockPos pos, @Nullable Player player) {
            this.world = world;
            this.pos = pos;
            this.player = player;
        }
    }
}

