/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.config;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.silentchaos512.scalinghealth.client.gui.difficulty.DifficultyMeterShow;
import net.silentchaos512.scalinghealth.client.gui.health.AbsorptionIconStyle;
import net.silentchaos512.scalinghealth.client.gui.health.HealthTextColor;
import net.silentchaos512.scalinghealth.client.gui.health.HealthTextStyle;
import net.silentchaos512.scalinghealth.client.gui.health.HeartIconStyle;
import net.silentchaos512.scalinghealth.config.ColorList;
import net.silentchaos512.utils.Anchor;
import net.silentchaos512.utils.Color;
import org.apache.commons.lang3.tuple.Pair;

public class SHConfig {
    private static final ForgeConfigSpec CLIENT_SPEC;
    private static final ForgeConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final Server SERVER;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
    }

    private static boolean validateColor(Object o) {
        return o instanceof Integer && Color.validate((String)o.toString());
    }

    static {
        Pair pCli = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)pCli.getRight();
        CLIENT = (Client)pCli.getLeft();
        Pair pSev = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)pSev.getRight();
        SERVER = (Server)pSev.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.EnumValue<Anchor> debugOverlayAnchor;
        public final ForgeConfigSpec.DoubleValue debugOverlayTextScale;
        public final ForgeConfigSpec.EnumValue<HeartIconStyle> heartIconStyle;
        public final ColorList heartColors;
        public final ForgeConfigSpec.BooleanValue lastHeartOutline;
        public final ForgeConfigSpec.ConfigValue<Integer> lastHeartOutlineColor;
        public final ForgeConfigSpec.BooleanValue heartColorLooping;
        public final ForgeConfigSpec.BooleanValue heartTanks;
        public final ForgeConfigSpec.EnumValue<HealthTextStyle> healthTextStyle;
        public final ForgeConfigSpec.DoubleValue healthTextScale;
        public final ForgeConfigSpec.IntValue healthTextOffsetX;
        public final ForgeConfigSpec.IntValue healthTextOffsetY;
        public final ForgeConfigSpec.EnumValue<HealthTextColor> healthTextColorStyle;
        public final ForgeConfigSpec.ConfigValue<Integer> healthTextFullColor;
        public final ForgeConfigSpec.ConfigValue<Integer> healthTextEmptyColor;
        public final ForgeConfigSpec.EnumValue<AbsorptionIconStyle> absorptionIconStyle;
        public final ColorList absorptionHeartColors;
        public final ForgeConfigSpec.EnumValue<HealthTextStyle> absorptionTextStyle;
        public final ForgeConfigSpec.IntValue absorptionTextOffsetX;
        public final ForgeConfigSpec.IntValue absorptionTextOffsetY;
        public final ForgeConfigSpec.ConfigValue<Integer> absorptionTextColor;
        public final ForgeConfigSpec.BooleanValue displayBlightEffect;
        public final ForgeConfigSpec.BooleanValue warnWhenSleeping;
        public final ForgeConfigSpec.EnumValue<DifficultyMeterShow> difficultyMeterShow;
        public final ForgeConfigSpec.DoubleValue difficultyMeterShowTime;
        public final ForgeConfigSpec.EnumValue<Anchor> difficultyMeterAnchor;
        public final ForgeConfigSpec.IntValue difficultyMeterOffsetX;
        public final ForgeConfigSpec.IntValue difficultyMeterOffsetY;
        public final ForgeConfigSpec.DoubleValue difficultyMeterTextScale;

        public Client(ForgeConfigSpec.Builder builder) {
            this.debugOverlayAnchor = builder.comment("Position of debug overlay").defineEnum("debug.overlay.anchor", (Enum)Anchor.TOP_RIGHT);
            this.debugOverlayTextScale = builder.comment("Overlay text size, where 1 is standard-sized text").defineInRange("debug.overlay.textScale", 0.75, 0.01, Double.MAX_VALUE);
            this.heartIconStyle = builder.comment(new String[]{"Heart style", "REPLACE_ALL: All rows replaced with Scaling Health style hearts", "REPLACE_AFTER_FIRST_ROW: Leave the first row vanilla style, Scaling Health style for additional rows", "VANILLA: Do not change heart rendering (use this if you want another mod to handle heart rendering)"}).defineEnum("hearts.health.icons.style", (Enum)HeartIconStyle.REPLACE_ALL);
            this.heartColors = new ColorList(builder, "hearts.health.icons.colors", "The color of each row of hearts. If the player has more rows than colors, it starts over from the beginning.", 0xBF0000, 0xE66000, 15112448, 15127296, 10085888, 5039616, 59033, 59110, 39398, 230, 10027238, 13992191, 0x8C8C8C, 0xE6E6E6);
            this.lastHeartOutline = builder.comment("The player's highest heart will get an outline around it.").define("hearts.health.icons.lastHeartOutline", true);
            this.lastHeartOutlineColor = builder.comment("The color of the last heart outline, if enabled (see lastHeartOutline)").define("hearts.health.icons.lastHeartOutlineColor", (Object)0xFFFFFF, SHConfig::validateColor);
            this.heartColorLooping = builder.comment(new String[]{"If true, heart colors will 'loop around' to the first color after going through the", "entire list. Set false to have every row after the last have the same color."}).define("hearts.health.icons.colorLooping", true);
            this.heartTanks = builder.comment("Enable heart tanks, the small icons above your hearts which indicate the number of filled health rows").define("hearts.health.tanks.enabled", true);
            this.healthTextStyle = builder.comment("Style of health text").defineEnum("hearts.health.text.style", (Enum)HealthTextStyle.ROWS);
            this.healthTextScale = builder.comment("Health text scale, relative to its normal size (which varies by style)").defineInRange("hearts.health.text.scale", 1.0, 0.01, Double.MAX_VALUE);
            this.healthTextOffsetX = builder.comment("Fine-tune text position").defineInRange("hearts.health.text.offsetX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.healthTextOffsetY = builder.comment("Fine-tune text position").defineInRange("hearts.health.text.offsetY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.healthTextColorStyle = builder.comment(new String[]{"Health text color style.", "TRANSITION: Gradually goes from full color to empty color as health is lost", "PSYCHEDELIC: Taste the rainbow!", "SOLID: Just stays at full color regardless of health"}).defineEnum("hearts.health.text.color.style", (Enum)HealthTextColor.TRANSITION);
            this.healthTextFullColor = builder.comment("Color when health is full or style is SOLID").define("hearts.health.text.color.full", (Object)0x4CFF4C, SHConfig::validateColor);
            this.healthTextEmptyColor = builder.comment("Color when health is empty and style is TRANSITION").define("hearts.health.text.color.empty", (Object)0xFF4C4C, SHConfig::validateColor);
            this.absorptionIconStyle = builder.comment("Style of absorption icons").defineEnum("hearts.absorption.icons.style", (Enum)AbsorptionIconStyle.SHIELD);
            this.absorptionHeartColors = new ColorList(builder, "hearts.absorption.icons.colors", "The color of each row of absorption hearts. If the player has more rows than colors, it starts over from the beginning.", 0xBF0000, 0xE66000, 15112448, 15127296, 10085888, 5039616, 59033, 59110, 39398, 230, 10027238, 13992191, 0x8C8C8C, 0xE6E6E6);
            this.absorptionTextStyle = builder.comment("Style for absorption text. Because there is no 'max' value, the options are more limited.").defineEnum("hearts.absorption.text.style", (Enum)HealthTextStyle.DISABLED, (Collection)ImmutableList.of((Object)((Object)HealthTextStyle.DISABLED), (Object)((Object)HealthTextStyle.HEALTH_ONLY), (Object)((Object)HealthTextStyle.ROWS)));
            this.absorptionTextOffsetX = builder.comment("Fine-tune text position").defineInRange("hearts.absorption.text.offsetX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.absorptionTextOffsetY = builder.comment("Fine-tune text position").defineInRange("hearts.absorption.text.offsetY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.absorptionTextColor = builder.comment("The color of the absorption text").define("hearts.absorption.text.color", (Object)0xFFFFFF, SHConfig::validateColor);
            this.warnWhenSleeping = builder.comment("Display a warning to players trying to sleep, to remind them their difficulty may change. Sleeping is still allowed.").define("difficulty.warnWhenSleeping", true);
            this.difficultyMeterShow = builder.comment("When to show the difficulty meter.").defineEnum("difficulty.meter.show", (Enum)DifficultyMeterShow.SOMETIMES);
            this.difficultyMeterShowTime = builder.comment("Show the difficulty meter for this many seconds (only on SOMETIMES mode)").defineInRange("difficulty.meter.showDuration", 8.0, 0.0, Double.MAX_VALUE);
            this.difficultyMeterAnchor = builder.comment("Position of the difficulty meter.").defineEnum("difficulty.meter.position.anchor", (Enum)Anchor.BOTTOM_LEFT);
            this.difficultyMeterOffsetX = builder.comment("Fine-tune the difficulty meter's position").defineInRange("difficulty.meter.position.offsetX", 5, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.difficultyMeterOffsetY = builder.comment("Fine-tune the difficulty meter's position").defineInRange("difficulty.meter.position.offsetY", -30, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.difficultyMeterTextScale = builder.comment("Scale of text on the difficulty meter").defineInRange("difficulty.meter.text.scale", 0.6, 0.0, Double.MAX_VALUE);
            this.displayBlightEffect = builder.comment(new String[]{"whether the purple flame should render on blights or not.", "This does not change whether the mob is a blight, only hides the effect."}).define("blights.render", true);
        }

        public void reload() {
            this.absorptionHeartColors.recalculate();
            this.heartColors.recalculate();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue debugMaster;
        public final Supplier<Boolean> debugShowOverlay;
        public final Supplier<Boolean> debugLogEntitySpawns;
        public final Supplier<Boolean> debugLogScaledDamage;
        public final Supplier<Boolean> debugMobPotionEffects;
        public final ForgeConfigSpec.BooleanValue crystalsAddHealth;
        public final ForgeConfigSpec.BooleanValue xpAddHealth;
        public final ForgeConfigSpec.BooleanValue crystalsRegenHealth;
        public final ForgeConfigSpec.BooleanValue crystalsAddPetHealth;
        public final ForgeConfigSpec.BooleanValue crystalsAddDamage;
        public final ForgeConfigSpec.BooleanValue hpCrystalsOreGen;
        public final ForgeConfigSpec.BooleanValue powerCrystalsOreGen;
        public final ForgeConfigSpec.BooleanValue mobDamageIncrease;
        public final ForgeConfigSpec.BooleanValue mobHpIncrease;
        public final ForgeConfigSpec.BooleanValue playerDamageScaling;
        public final ForgeConfigSpec.BooleanValue mobDamageScaling;
        public final ForgeConfigSpec.BooleanValue enableDifficulty;
        public final ForgeConfigSpec.BooleanValue enableBlights;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("All SH features can be disabled here. False to disable.").push("features");
            this.crystalsAddHealth = builder.comment("Enable player bonus hp by crystals.").define("crystalsAddHealth", true);
            this.xpAddHealth = builder.comment("Enable player bonus hp by xp.").define("xpAddHealth", true);
            this.crystalsRegenHealth = builder.comment("Enable player regen hp by crystals.").define("crystalsRegenHealth", true);
            this.crystalsAddPetHealth = builder.comment("Enable pet add hp by crystals.").define("crystalsAddPetHealth", true);
            this.crystalsAddDamage = builder.comment("Enable player add damage by crystals.").define("crystalsAddDamage", true);
            this.hpCrystalsOreGen = builder.comment("Enable ore gen of health crystals. Still drops as loot.").define("hpCrystalsOreGen", true);
            this.powerCrystalsOreGen = builder.comment("Enable ore gen of power crystals. Still drops as loot.").define("powerCrystalsOreGen", true);
            this.mobHpIncrease = builder.comment("Mobs will gain bonus health with difficulty.").define("mobHpIncrease", true);
            this.mobDamageIncrease = builder.comment("Mobs will gain bonus damage with difficulty.").define("mobDamageIncrease", true);
            this.playerDamageScaling = builder.comment("Enable player damage scaling.").define("playerDamageScaling", true);
            this.mobDamageScaling = builder.comment("Enable mob damage scaling.").define("mobDamageScaling", true);
            this.enableDifficulty = builder.comment("Enable difficulty system. If disabled, everything will have 0 difficulty.").define("enableDifficulty", true);
            this.enableBlights = builder.comment("Enable blights. If disabled, no blights will spawn.").define("enableBlights", true);
            builder.pop().comment(new String[]{"Debug settings are intended for tuning configs or diagnosing issues.", "They may decrease performance and should be disabled for normal play."}).push("debug");
            this.debugMaster = builder.comment("Must be true for other debug settings to apply").define("masterSwitch", false);
            this.debugShowOverlay = this.withMasterCheck(builder.comment("Show some text in-game about player health, difficulty, and maybe other things.").define("showOverlay", true));
            this.debugLogEntitySpawns = this.withMasterCheck(builder.comment(new String[]{"Log details of entity spawns, including effects of difficulty.", "This creates a lot of log spam, and will likely lag the game."}).define("logEntitySpawns", false));
            this.debugMobPotionEffects = this.withMasterCheck(builder.comment("Logs details of potions effects added to mobs.").define("logApplyingMobPotions", false));
            this.debugLogScaledDamage = this.withMasterCheck(builder.comment(new String[]{"Log details of scaled damage, useful for fine-tuning damage scaling.", "May create a fair amount of log spam, but shouldn't slow down the game too much."}).define("logDamageScaling", false));
        }

        private Supplier<Boolean> withMasterCheck(ForgeConfigSpec.BooleanValue option) {
            return () -> (Boolean)this.debugMaster.get() != false && (Boolean)option.get() != false;
        }
    }
}

