/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.datagen;

import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.loot.conditions.SHMobProperties;
import net.silentchaos512.scalinghealth.objects.Registration;
import net.silentchaos512.scalinghealth.utils.EntityGroup;

public class MobTables
implements LootTableSubProvider {
    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        consumer.accept(MobTables.fromGroup(EntityGroup.HOSTILE), MobTables.createSHDropsTable(MobTables.createSHDropsPool(1, new MobLootCondition(true, false, 0, 0.055f, 0.005f), new MobLootEntry((Item)Registration.HEART_CRYSTAL.get(), 12, 1, 0), new MobLootEntry((Item)Registration.POWER_CRYSTAL.get(), 4, 1, 0), new MobLootEntry((Item)Registration.HEART_CRYSTAL_SHARD.get(), 2, 11, 3), new MobLootEntry((Item)Registration.POWER_CRYSTAL_SHARD.get(), 1, 12, 2)), MobTables.createSHDropsPool(1, new MobLootCondition(false, false, 10, 0.025f, 0.005f), new MobLootEntry((Item)Registration.BANDAGES.get(), 10, 2, 0), new MobLootEntry((Item)Registration.MEDKIT.get(), 1, 1, 0)), MobTables.createSHDropsPool(1, new MobLootCondition(false, false, 70, 0.015f, 0.025f), new MobLootEntry((Item)Registration.CHANCE_HEART.get(), 1, 1, 0), new MobLootEntry((Item)Registration.ENCHANTED_HEART.get(), 1, 1, 0)), MobTables.createSHDropsPool(1, new MobLootCondition(true, true, 0, 0.0f, 0.0f), new MobLootEntry((Item)Registration.HEART_CRYSTAL.get(), 10, 3, 1), new MobLootEntry((Item)Registration.POWER_CRYSTAL.get(), 5, 2, 1))));
        consumer.accept(MobTables.fromGroup(EntityGroup.PEACEFUL), MobTables.createSHDropsTable(MobTables.createSHDropsPool(1, new MobLootCondition(true, false, 0, 0.055f, 0.005f), new MobLootEntry((Item)Registration.HEART_CRYSTAL_SHARD.get(), 2, 8, 1), new MobLootEntry((Item)Registration.POWER_CRYSTAL_SHARD.get(), 1, 5, 0)), MobTables.createSHDropsPool(1, new MobLootCondition(false, false, 0, 0.015f, 0.025f), new MobLootEntry((Item)Registration.CURSED_HEART.get(), 1, 1, 0)), MobTables.createSHDropsPool(1, new MobLootCondition(true, true, 0, 0.0f, 0.0f), new MobLootEntry((Item)Registration.HEART_CRYSTAL.get(), 5, 1, -1), new MobLootEntry((Item)Registration.POWER_CRYSTAL.get(), 2, 1, -1))));
    }

    public static ResourceLocation fromGroup(EntityGroup group) {
        return ScalingHealth.getId("bonus_drops/" + group.name().toLowerCase(Locale.ROOT));
    }

    public static LootTable.Builder createSHDropsTable(LootPool.Builder ... pools) {
        LootTable.Builder table = LootTable.m_79147_();
        for (LootPool.Builder pool : pools) {
            table.m_79161_(pool);
        }
        return table;
    }

    public static LootPool.Builder createSHDropsPool(int rolls, MobLootCondition conditions, MobLootEntry ... entries) {
        LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)rolls));
        for (MobLootEntry entry : entries) {
            if (entry.isCount()) {
                builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)entry.item).m_79707_(entry.weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)entry.max))));
                continue;
            }
            builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)entry.item).m_79707_(entry.weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)entry.min, (float)entry.max))));
        }
        if (conditions.hasDiffCond() || conditions.blight) {
            builder.m_79080_(SHMobProperties.builder(LootContext.EntityTarget.THIS, conditions.blight, conditions.difficulty, 2.1474836E9f));
        }
        if (conditions.hasLootCond()) {
            builder.m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)conditions.lootingChance, (float)conditions.lootingMulti));
        }
        if (conditions.playerKill) {
            builder.m_79080_(LootItemKilledByPlayerCondition.m_81901_());
        }
        return builder;
    }

    public static class MobLootCondition {
        boolean playerKill;
        boolean blight;
        int difficulty;
        float lootingChance;
        float lootingMulti;

        MobLootCondition(boolean pk, boolean blight, int difficulty, float lootingChance, float lootingMulti) {
            this.difficulty = difficulty;
            this.lootingChance = lootingChance;
            this.lootingMulti = lootingMulti;
            this.playerKill = pk;
            this.blight = blight;
        }

        boolean hasDiffCond() {
            return this.difficulty != 0;
        }

        boolean hasLootCond() {
            return this.lootingMulti != 0.0f && this.lootingChance != 0.0f;
        }
    }

    public static class MobLootEntry {
        int weight;
        int max;
        int min;
        Item item;

        MobLootEntry(Item item, int weight, int max, int min) {
            this.max = max;
            this.min = min;
            this.weight = weight;
            this.item = item;
        }

        boolean isCount() {
            return this.min == 0 && this.max == 1;
        }
    }
}

