/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="scalinghealth")
public class BlightRenderEvent {
    private static final float FIRE_SCALE = 1.8f;
    private static final ResourceLocation TEXTURE = ScalingHealth.getId("textures/entity/blightfire.png");
    private static RenderType RENDER_TYPE;

    @SubscribeEvent
    public static void renderBlight(RenderLivingEvent<Mob, ? extends EntityModel<? extends Mob>> event) {
        if (RENDER_TYPE == null) {
            RENDER_TYPE = RenderType.m_110452_((ResourceLocation)TEXTURE);
        }
        LivingEntity entity = event.getEntity();
        if (EnabledFeatures.shouldRenderBlights() && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (SHDifficulty.affected((ICapabilityProvider)entity).isBlight()) {
                PoseStack stack = event.getPoseStack();
                int light = event.getPackedLight();
                stack.m_85836_();
                float w = mob.m_20205_() * 1.8f;
                stack.m_85841_(w, w, w);
                float hwRatio = mob.m_20206_() / w;
                float xOffset = 0.5f;
                float yOffset = (float)(mob.m_20186_() - mob.m_20191_().f_82289_);
                float zOffset = 0.0f;
                Quaternionf cam = Minecraft.m_91087_().m_91290_().m_253208_();
                stack.m_252781_(new Quaternionf(0.0f, cam.y, 0.0f, cam.w));
                stack.m_252880_(0.0f, 0.0f, hwRatio * 0.02f);
                int i = 0;
                VertexConsumer vertexBuilder = event.getMultiBufferSource().m_6299_(RENDER_TYPE);
                Matrix4f matrix4f = stack.m_85850_().m_252922_();
                Matrix3f matrix3f = stack.m_85850_().m_252943_();
                while (hwRatio > 0.0f) {
                    boolean swapU = i % 2 == 0;
                    int frame = ClientTicks.ticksInGame() % 32;
                    float minU = swapU ? 0.5f : 0.0f;
                    float minV = (float)frame / 32.0f;
                    float maxU = swapU ? 1.0f : 0.5f;
                    float maxV = (float)(frame + 1) / 32.0f;
                    if (swapU) {
                        float swap = maxU;
                        maxU = minU;
                        minU = swap;
                    }
                    vertexBuilder.m_252986_(matrix4f, xOffset, 0.0f - yOffset, zOffset).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                    vertexBuilder.m_252986_(matrix4f, -xOffset, 0.0f - yOffset, zOffset).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                    vertexBuilder.m_252986_(matrix4f, -xOffset, 1.4f - yOffset, zOffset).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                    vertexBuilder.m_252986_(matrix4f, xOffset, 1.4f - yOffset, zOffset).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                    hwRatio -= 0.45f;
                    yOffset -= 0.45f;
                    xOffset *= 0.9f;
                    zOffset += 0.03f;
                    ++i;
                }
                stack.m_85849_();
            }
        }
    }
}

