/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.scalinghealth.network.ClientLoginMessage;
import net.silentchaos512.scalinghealth.network.Network;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHMobs;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;
import net.silentchaos512.utils.MathUtils;

@Mod.EventBusSubscriber(modid="scalinghealth")
public final class CommonEvents {
    public static List<UUID> spawnerSpawns = new ArrayList<UUID>();
    private static boolean changedLevelThisTick = false;

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        SHPlayers.getPlayerData(player).updateStats(player);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)event.getEntity();
        ScalingHealth.LOGGER.debug("Sending login packet to player {}", (Object)player);
        ClientLoginMessage msg = new ClientLoginMessage(SHDifficulty.areaMode(), (float)SHDifficulty.maxValue());
        Network.channel.sendTo((Object)msg, sp.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public static void onSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getSpawner() != null) {
            spawnerSpawns.add(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMobXPDropped(LivingExperienceDropEvent event) {
        LivingEntity entity = event.getEntity();
        short difficulty = (short)SHDifficulty.areaDifficulty(entity.m_9236_(), entity.m_20183_());
        float multi = (float)(1.0 + SHMobs.xpBoost() * (double)difficulty);
        float amount = event.getDroppedExperience();
        amount *= multi;
        if (entity instanceof Mob && SHMobs.isBlight((Mob)entity)) {
            amount = (float)((double)amount * SHMobs.xpBlightBoost());
        }
        event.setDroppedExperience(Math.round(amount));
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().f_46443_ || !player.m_6084_()) {
            return;
        }
        SHPlayers.getPlayerData(player).tick(player);
        if (changedLevelThisTick) {
            changedLevelThisTick = false;
            SHPlayers.getPlayerData(player).updateStats(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLevelChange(PlayerXpEvent.LevelChange event) {
        if (!EnabledFeatures.healthXpEnabled() || event.isCanceled()) {
            return;
        }
        changedLevelThisTick = true;
    }

    @SubscribeEvent
    public static void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_ && ((Boolean)SHConfig.CLIENT.warnWhenSleeping.get()).booleanValue()) {
            double newDifficulty = SHDifficulty.diffOnPlayerSleep(player);
            if (!MathUtils.doublesEqual((double)SHDifficulty.getDifficultyOf((Entity)player), (double)newDifficulty, (double)0.1)) {
                ScalingHealth.LOGGER.debug("old={}, new={}", (Object)SHDifficulty.getDifficultyOf((Entity)player), (Object)newDifficulty);
                player.m_213846_((Component)Component.m_237115_((String)"misc.scalinghealth.sleepWarning"));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_ && !event.updateLevel()) {
            SHDifficulty.setSourceDifficulty(player, SHDifficulty.diffOnPlayerSleep(player));
        }
    }
}

