/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.scalinghealth.resources.mechanics.DamageScalingMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.utils.EntityGroup;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="scalinghealth")
public final class DamageScaling {
    private static final Marker MARKER = MarkerManager.getMarker((String)"DamageScaling");
    private static final Set<UUID> ENTITY_ATTACKED_THIS_TICK = new HashSet<UUID>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityHurt(LivingAttackEvent event) {
        float original;
        float affectedAmount;
        LivingEntity entity;
        block10: {
            block9: {
                if (!EnabledFeatures.mobDamageScalingEnabled() && !EnabledFeatures.playerDamageScalingEnabled()) {
                    return;
                }
                entity = event.getEntity();
                if (entity.m_9236_().f_46443_) {
                    return;
                }
                if (entity.m_6673_(event.getSource())) break block9;
                int n = entity.f_19802_;
                Objects.requireNonNull(entity);
                if (n <= 20 / 2) break block10;
            }
            return;
        }
        if (ENTITY_ATTACKED_THIS_TICK.contains(entity.m_20148_()) || !EntityGroup.from(entity).isAffectedByDamageScaling()) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        float scale = SHMechanics.getMechanics().damageScalingMechanics().scales.stream().filter(p -> ((List)p.getFirst()).contains(source.m_19385_())).map(Pair::getSecond).reduce((s1, s2) -> s1 * s2).orElseGet(() -> SHMechanics.getMechanics().damageScalingMechanics().genericScale).floatValue();
        float change = scale * (affectedAmount = (float)DamageScaling.getEffectScale(entity)) * (original = event.getAmount());
        if (change > 1.0E-4f) {
            float newAmount = DamageScaling.makeSane(event.getAmount() + change);
            event.setCanceled(true);
            ENTITY_ATTACKED_THIS_TICK.add(entity.m_20148_());
            entity.m_6469_(event.getSource(), newAmount);
            if (SHConfig.SERVER.debugLogScaledDamage.get().booleanValue()) {
                ScalingHealth.LOGGER.debug(MARKER, "{} on {}: {} -> {} (scale={}, affected={}, change={})", (Object)source.m_19385_(), (Object)entity.m_6302_(), (Object)Float.valueOf(original), (Object)Float.valueOf(newAmount), (Object)Float.valueOf(scale), (Object)Float.valueOf(affectedAmount), (Object)Float.valueOf(change));
            }
        }
    }

    private static double getEffectScale(LivingEntity entity) {
        DamageScalingMechanics config = SHMechanics.getMechanics().damageScalingMechanics();
        Mode mode = config.mode;
        switch (mode) {
            case AREA_DIFFICULTY: {
                return SHDifficulty.areaDifficulty(entity.m_9236_(), entity.m_20183_()) * config.difficultyWeight;
            }
            case MAX_HEALTH: {
                AttributeInstance attr = entity.m_21051_(Attributes.f_22276_);
                if (attr == null) {
                    ScalingHealth.LOGGER.warn("Living Entity {} has no max health attribute", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
                    return 1.0;
                }
                double baseHealth = entity instanceof Player ? (double)SHPlayers.startingHealth() : attr.m_22115_();
                return ((double)entity.m_21233_() - baseHealth) / baseHealth;
            }
            case DIFFICULTY: {
                return SHDifficulty.getDifficultyOf((Entity)entity) * config.difficultyWeight;
            }
        }
        throw new IllegalStateException("Unknown damage scaling mode: " + mode);
    }

    private static float makeSane(float scaledAmount) {
        if (scaledAmount < 0.0f) {
            return 0.0f;
        }
        if (!Float.isFinite(scaledAmount)) {
            return Float.MAX_VALUE;
        }
        return scaledAmount;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ENTITY_ATTACKED_THIS_TICK.clear();
    }

    public static enum Mode implements StringRepresentable
    {
        MAX_HEALTH,
        DIFFICULTY,
        AREA_DIFFICULTY;

        public static final Codec<Mode> CODEC;

        public String m_7912_() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.m_216439_(Mode::values);
        }
    }
}

