/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.DifficultyAffectedCapability;
import net.silentchaos512.scalinghealth.capability.DifficultySourceCapability;
import net.silentchaos512.scalinghealth.capability.PetHealthCapability;
import net.silentchaos512.scalinghealth.capability.PlayerDataCapability;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="scalinghealth")
public final class DifficultyEvents {
    private static final boolean PRINT_DEBUG_INFO = true;
    public static final Marker MARKER = MarkerManager.getMarker((String)"Difficulty");
    private static Field validCap;

    private DifficultyEvents() {
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (DifficultyAffectedCapability.canAttachTo((ICapabilityProvider)entity)) {
            event.addCapability(DifficultyAffectedCapability.NAME, (ICapabilityProvider)new DifficultyAffectedCapability());
        }
        if (EnabledFeatures.difficultyEnabled() && DifficultySourceCapability.canAttachTo((ICapabilityProvider)entity)) {
            DifficultyEvents.debug(() -> "attach source to player");
            event.addCapability(DifficultySourceCapability.NAME, (ICapabilityProvider)new DifficultySourceCapability());
        }
        if (PlayerDataCapability.canAttachTo((ICapabilityProvider)entity)) {
            DifficultyEvents.debug(() -> "attach player data");
            event.addCapability(PlayerDataCapability.NAME, (ICapabilityProvider)new PlayerDataCapability());
        }
        if (EnabledFeatures.petBonusHpEnabled() && PetHealthCapability.canAttachTo((ICapabilityProvider)entity)) {
            DifficultyEvents.debug(() -> "attach pet data");
            event.addCapability(PetHealthCapability.NAME, (ICapabilityProvider)new PetHealthCapability());
        }
    }

    @SubscribeEvent
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        Level world = (Level)event.getObject();
        if (((Boolean)SHConfig.SERVER.enableDifficulty.get()).booleanValue() && DifficultySourceCapability.canAttachTo((ICapabilityProvider)world)) {
            DifficultyEvents.debug(() -> "attach source to world");
            DifficultySourceCapability cap = new DifficultySourceCapability();
            event.addCapability(DifficultySourceCapability.NAME, (ICapabilityProvider)cap);
            DifficultySourceCapability.setOverworldCap(cap);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_ || entity.m_9236_().m_6907_().isEmpty() && !((ServerLevel)entity.m_9236_()).m_7654_().m_6982_()) {
            return;
        }
        if (entity instanceof Mob) {
            entity.getCapability(DifficultyAffectedCapability.INSTANCE).ifPresent(data -> data.tick((Mob)entity));
        }
        if (entity instanceof TamableAnimal) {
            if (!((TamableAnimal)entity).m_21824_()) {
                return;
            }
            entity.getCapability(PetHealthCapability.INSTANCE).ifPresent(data -> data.tick((TamableAnimal)entity));
        }
        if (entity instanceof Player && entity.m_9236_().m_46467_() % 20L == 0L) {
            entity.getCapability(DifficultySourceCapability.INSTANCE).ifPresent(source -> source.addDifficulty((float)SHDifficulty.changePerSecond()));
        }
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        TamableAnimal pet;
        LivingEntity killed = event.getEntity();
        if (event.getSource() == null || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entitySource = event.getSource().m_7639_();
        if (entitySource instanceof Player) {
            SHDifficulty.applyKillMutator(killed, (Player)entitySource);
            return;
        }
        if (entitySource instanceof TamableAnimal && ((TamableAnimal)entitySource).m_21824_() && (pet = (TamableAnimal)entitySource).m_269323_() instanceof Player) {
            SHDifficulty.applyKillMutator(killed, (Player)pet.m_269323_());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Level world = event.level;
        if (world.f_46443_) {
            return;
        }
        if (world.m_46467_() % 20L == 0L) {
            world.getCapability(DifficultySourceCapability.INSTANCE).ifPresent(source -> {
                float change = (float)SHDifficulty.changePerSecond();
                source.setDifficulty(source.getDifficulty() + change);
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (validCap == null) {
            try {
                validCap = CapabilityProvider.class.getDeclaredField("valid");
                validCap.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not access field!", e);
            }
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        try {
            validCap.set(original, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set capability field!");
        }
        DifficultyEvents.copyCapability(PlayerDataCapability.INSTANCE, (ICapabilityProvider)original, (ICapabilityProvider)clone);
        DifficultyEvents.copyCapability(DifficultySourceCapability.INSTANCE, (ICapabilityProvider)original, (ICapabilityProvider)clone);
        original.invalidateCaps();
        if (!event.isWasDeath()) {
            return;
        }
        clone.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
            data.updateStats(clone);
            int newCrystals = SHPlayers.getCrystalsAfterDeath(clone);
            DifficultyEvents.notifyOfChanges(clone, "heart crystal(s)", data.getHeartCrystals(), newCrystals);
            data.setHeartCrystals(clone, newCrystals);
        });
        clone.getCapability(DifficultySourceCapability.INSTANCE).ifPresent(source -> {
            float newDifficulty = (float)SHDifficulty.getDifficultyAfterDeath(clone);
            DifficultyEvents.notifyOfChanges(clone, "difficulty", source.getDifficulty(), newDifficulty);
            source.setDifficulty(newDifficulty);
        });
    }

    private static void notifyOfChanges(Player player, String valueName, float oldValue, float newValue) {
        float diff = newValue - oldValue;
        String line = String.format("%s %.2f %s", diff > 0.0f ? "gained" : "lost", Float.valueOf(diff), valueName);
        if (diff != 0.0f) {
            player.m_213846_((Component)Component.m_237115_((String)line));
        }
        ScalingHealth.LOGGER.info("Player {}", (Object)line);
    }

    private static <T> void copyCapability(Capability<T> capability, ICapabilityProvider original, ICapabilityProvider clone) {
        original.getCapability(capability).ifPresent(dataOriginal -> clone.getCapability(capability).ifPresent(dataClone -> {
            if (dataOriginal instanceof INBTSerializable) {
                INBTSerializable originalS = (INBTSerializable)dataOriginal;
                if (dataClone instanceof INBTSerializable) {
                    INBTSerializable cloneS = (INBTSerializable)dataClone;
                    cloneS.deserializeNBT(originalS.serializeNBT());
                }
            }
        }));
    }

    private static void debug(Supplier<?> msg) {
        if (((Boolean)SHConfig.SERVER.debugMaster.get()).booleanValue()) {
            ScalingHealth.LOGGER.debug(MARKER, msg.get());
        }
    }
}

