/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.scalinghealth.objects.item.HeartCrystal;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;

@Mod.EventBusSubscriber(modid="scalinghealth", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PetEventHandler {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        double regenDelay = SHMechanics.getMechanics().mobMechanics().pets().petsRegenDelay();
        if (regenDelay <= 0.0) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity != null && !entity.m_9236_().f_46443_) {
            boolean isRegenTime;
            boolean fullHp = entity.m_21223_() == entity.m_21233_();
            boolean isTamed = entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_();
            boolean bl = isRegenTime = entity.f_19802_ <= 0 && (double)entity.f_19797_ % regenDelay == 0.0;
            if (isTamed && isRegenTime && !fullHp) {
                entity.m_5634_(2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPetInteraction(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!(EnabledFeatures.petBonusHpEnabled() && event.getItemStack().m_41720_() instanceof HeartCrystal && event.getTarget() instanceof TamableAnimal)) {
            return;
        }
        TamableAnimal pet = (TamableAnimal)event.getTarget();
        if (!pet.m_21824_()) {
            return;
        }
        if (pet.m_9236_().f_46443_) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        HeartCrystal heart = (HeartCrystal)event.getItemStack().m_41720_();
        heart.increasePetHp(event.getEntity(), pet, event.getItemStack());
    }
}

