/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.resources.mechanics.PlayerMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;

@Mod.EventBusSubscriber(modid="scalinghealth")
public final class PlayerBonusRegenHandler {
    private static final Map<UUID, Integer> TIMERS = new HashMap<UUID, Integer>();

    private PlayerBonusRegenHandler() {
    }

    public static int getTimerForPlayer(Player player) {
        if (player == null) {
            return -1;
        }
        UUID uuid = player.m_20148_();
        return TIMERS.getOrDefault(uuid, -1);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        Player player = event.player;
        if (PlayerBonusRegenHandler.isDisabled(player.m_9236_())) {
            return;
        }
        PlayerMechanics.RegenMechanics config = SHMechanics.getMechanics().playerMechanics().regenMechanics;
        UUID uuid = player.m_20148_();
        if (!TIMERS.containsKey(uuid)) {
            TIMERS.put(uuid, (int)(config.initialDelay * 20.0));
        }
        if (PlayerBonusRegenHandler.isActive((LivingEntity)player)) {
            int timer = TIMERS.get(uuid);
            if (--timer <= 0) {
                player.m_5634_(PlayerBonusRegenHandler.getHealTickAmount((LivingEntity)player));
                player.m_36399_((float)config.exhaustion);
                timer = (int)(20.0 * config.tickDelay);
            }
            TIMERS.put(uuid, timer);
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (PlayerBonusRegenHandler.isDisabled(entity.m_9236_())) {
            return;
        }
        if (!entity.m_9236_().f_46443_ && entity instanceof Player) {
            TIMERS.put(entity.m_20148_(), (int)(SHMechanics.getMechanics().playerMechanics().regenMechanics.initialDelay * 20.0));
        }
    }

    private static float getHealTickAmount(LivingEntity entity) {
        if (SHMechanics.getMechanics().playerMechanics().regenMechanics.proportionaltoMaxHp) {
            AttributeInstance attr = entity.m_21051_(Attributes.f_22276_);
            if (attr == null) {
                ScalingHealth.LOGGER.warn("LivingEntity {} does not have a max hp attribute!", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
                return 0.0f;
            }
            double base = attr.m_22115_();
            double max = attr.m_22135_();
            return (float)(max / base);
        }
        return 1.0f;
    }

    private static boolean isActive(LivingEntity entity) {
        Player player;
        int food;
        PlayerMechanics.RegenMechanics config = SHMechanics.getMechanics().playerMechanics().regenMechanics;
        if (!entity.m_6084_() || entity.m_21223_() >= entity.m_21233_()) {
            return false;
        }
        if (entity instanceof Player && ((food = (player = (Player)entity).m_36324_().m_38702_()) < config.minFood || food > config.maxFood)) {
            return false;
        }
        float health = entity.m_21223_();
        return health >= (float)config.regenMinHealth && health <= (float)config.regenMaxHealth;
    }

    private static boolean isDisabled(Level level) {
        return !level.m_46469_().m_46207_(GameRules.f_46139_);
    }
}

