/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.silentchaos512.scalinghealth.objects.item.DifficultyMutatorItem;
import net.silentchaos512.scalinghealth.objects.item.PowerCrystal;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;

public class TableGlobalModifier
extends LootModifier {
    public static final Supplier<Codec<TableGlobalModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> TableGlobalModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.f_135803_.xmap(r -> (LootTableReference)LootTableReference.m_79776_((ResourceLocation)r).m_7512_(), lt -> lt.f_79754_).fieldOf("table").forGetter(m -> m.table)).apply((Applicative)inst, TableGlobalModifier::new)));
    private final LootTableReference table;

    public TableGlobalModifier(LootItemCondition[] conditions, LootTableReference table) {
        super(conditions);
        this.table = table;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        this.table.m_6948_(arg_0 -> generatedLoot.add(arg_0), context);
        generatedLoot.forEach(stack -> {
            if (EnabledFeatures.powerCrystalEnabled() && stack.m_41720_() instanceof PowerCrystal || !EnabledFeatures.difficultyEnabled() && stack.m_41720_() instanceof DifficultyMutatorItem) {
                stack.m_41764_(0);
            }
        });
        return generatedLoot;
    }
}

