/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.objects.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.objects.Registration;

public class HealingItem
extends Item {
    private static final int USE_TIME = 100;
    private final float healAmount;
    private final int healSpeed;
    private final int effectDuration;

    public HealingItem(float healAmount, int healSpeed) {
        super(new Item.Properties().m_41487_(16));
        this.healAmount = healAmount;
        this.healSpeed = healSpeed;
        this.effectDuration = (int)(this.healAmount * 100.0f * 20.0f * 2.0f / (float)this.healSpeed);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21223_() < player.m_21233_() && !player.m_21023_((MobEffect)Registration.BANDAGED.get())) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (!world.f_46443_) {
            entityLiving.m_7292_(new MobEffectInstance((MobEffect)Registration.BANDAGED.get(), this.effectDuration, this.healSpeed, false, false));
            stack.m_41774_(1);
            if (entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
        return stack;
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        if (count % 10 == 0) {
            player.m_5496_(SoundEvents.f_11678_, 1.25f, (float)((double)1.1f + (double)0.05f * ScalingHealth.RANDOM.nextGaussian()));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"item.scalinghealth.healing_item.value", (Object[])new Object[]{(int)(this.healAmount * 100.0f), this.effectDuration / 20}));
        tooltip.add((Component)Component.m_237110_((String)"item.scalinghealth.healing_item.howToUse", (Object[])new Object[]{5}));
    }
}

