/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.objects.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.objects.Registration;
import net.silentchaos512.scalinghealth.objects.item.StatBoosterItem;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHItems;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;
import net.silentchaos512.utils.MathUtils;

public class HeartCrystal
extends StatBoosterItem {
    public HeartCrystal(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected int getLevelCost(Player player) {
        return SHItems.levelCostToUseHeartCrystal(player);
    }

    @Override
    protected boolean isStatIncreaseAllowed(Player player) {
        return EnabledFeatures.healthCrystalEnabled() && SHPlayers.getPlayerData(player).getBonusHearts(player) < SHPlayers.maxHealth();
    }

    @Override
    protected boolean shouldConsume(Player player) {
        return EnabledFeatures.healthCrystalRegenEnabled() && player.m_21223_() < player.m_21233_();
    }

    @Override
    protected void extraConsumeEffect(Player player) {
        int current = (int)player.m_21223_();
        double healAmount = SHItems.heartCrystalHpBonusRegen();
        EntityHelper.heal((LivingEntity)player, (float)((float)healAmount), (boolean)true);
        int newHealth = (int)player.m_21223_();
        if (!MathUtils.doublesEqual((double)((double)current + healAmount), (double)newHealth)) {
            ScalingHealth.LOGGER.warn("Another mod seems to have canceled healing from a heart container (player {})", (Object)player.m_7755_());
        }
    }

    @Override
    protected void increaseStat(Player player) {
        SHPlayers.getPlayerData(player).addHeartCrystals(player, SHItems.heartCrystalIncreaseAmount());
    }

    @Override
    protected ParticleOptions getParticleType() {
        return (ParticleOptions)Registration.HEART_CRYSTAL_PARTICLE.get();
    }

    @Override
    protected SoundEvent getSoundEffect() {
        return (SoundEvent)Registration.HEART_CRYSTAL_USE.get();
    }
}

