/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.objects.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.silentchaos512.scalinghealth.objects.Registration;
import net.silentchaos512.scalinghealth.objects.item.StatBoosterItem;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHItems;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;

public class PowerCrystal
extends StatBoosterItem {
    public PowerCrystal(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected int getLevelCost(Player player) {
        return SHItems.levelCostToUsePowerCrystal(player);
    }

    @Override
    protected boolean isStatIncreaseAllowed(Player player) {
        return EnabledFeatures.powerCrystalEnabled() && (double)SHPlayers.getPlayerData(player).getPowerCrystals() * SHItems.powerCrystalIncreaseAmount() <= SHPlayers.maxAttackDamage();
    }

    @Override
    protected boolean shouldConsume(Player player) {
        return false;
    }

    @Override
    protected void extraConsumeEffect(Player player) {
    }

    @Override
    protected void increaseStat(Player player) {
        SHPlayers.getPlayerData(player).addPowerCrystal(player);
    }

    @Override
    protected ParticleOptions getParticleType() {
        return (ParticleOptions)Registration.POWER_CRYSTAL_PARTICLE.get();
    }

    @Override
    protected SoundEvent getSoundEffect() {
        return (SoundEvent)Registration.HEART_CRYSTAL_USE.get();
    }
}

