/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHMobs;

public enum EntityGroup {
    PEACEFUL,
    HOSTILE,
    BOSS,
    BLIGHT,
    PLAYER;


    public static EntityGroup from(LivingEntity entity) {
        return EntityGroup.from(entity, false);
    }

    public static EntityGroup from(String name) {
        for (EntityGroup group : EntityGroup.values()) {
            if (!group.name().equalsIgnoreCase(name)) continue;
            return group;
        }
        throw new RuntimeException("Could not get an entity group from name: " + name);
    }

    public static EntityGroup from(LivingEntity entity, boolean ignoreBlightStatus) {
        if (entity instanceof Player) {
            return PLAYER;
        }
        if (entity instanceof Enemy) {
            if (!ignoreBlightStatus && SHMobs.isBlight((Mob)entity)) {
                return BLIGHT;
            }
            return HOSTILE;
        }
        return PEACEFUL;
    }

    public double getPotionChance() {
        if (this == PEACEFUL) {
            return SHMobs.passivePotionChance();
        }
        return SHMobs.hostilePotionChance();
    }

    public boolean isAffectedByDamageScaling() {
        switch (this) {
            case PLAYER: {
                return EnabledFeatures.playerDamageScalingEnabled();
            }
            case PEACEFUL: {
                return SHMechanics.getMechanics().damageScalingMechanics().affectPeaceful;
            }
        }
        return SHMechanics.getMechanics().damageScalingMechanics().affectHostiles;
    }
}

