/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.IDifficultyAffected;
import net.silentchaos512.scalinghealth.event.BlightHandler;
import net.silentchaos512.scalinghealth.event.CommonEvents;
import net.silentchaos512.scalinghealth.network.ClientBlightMessage;
import net.silentchaos512.scalinghealth.network.Network;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHMobs;
import net.silentchaos512.scalinghealth.utils.mode.MobHealthMode;
import net.silentchaos512.utils.MathUtils;

public final class MobDifficultyHandler {
    private MobDifficultyHandler() {
    }

    public static void process(Mob entity, IDifficultyAffected data) {
        if (!entity.m_6084_()) {
            return;
        }
        MobDifficultyHandler.setEntityProperties(entity, data, MobDifficultyHandler.shouldBecomeBlight(entity, data.getDifficulty()));
    }

    public static boolean shouldBecomeBlight(Mob entity, float difficulty) {
        if (!SHMobs.canBecomeBlight(entity)) {
            return false;
        }
        double chance = MobDifficultyHandler.getBlightChance(difficulty);
        if (chance == 1.0) {
            return true;
        }
        return MathUtils.tryPercentage((Random)ScalingHealth.RANDOM, (double)chance);
    }

    private static double getBlightChance(float difficulty) {
        return SHMobs.blightChance() * (double)difficulty / SHDifficulty.maxValue();
    }

    public static void setEntityProperties(Mob entity, IDifficultyAffected data, boolean makeBlight) {
        float difficulty;
        if (!entity.m_6084_()) {
            return;
        }
        boolean isHostile = entity instanceof Enemy;
        if (makeBlight) {
            data.setIsBlight(true);
            ClientBlightMessage msg = new ClientBlightMessage(entity.m_19879_());
            Network.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)msg);
            BlightHandler.applyBlightPotionEffects(entity);
            if (entity instanceof WitherBoss || entity instanceof EnderDragon) {
                MutableComponent blight = Component.m_237110_((String)"misc.scalinghealth.blight", (Object[])new Object[]{entity.m_5446_()}).m_6881_().m_130940_(ChatFormatting.DARK_PURPLE);
                entity.m_6593_((Component)blight);
            }
        }
        if ((difficulty = data.affectiveDifficulty()) <= 0.0f) {
            return;
        }
        SHMobs.getMobEffects().forEach(c -> c.tryApply((LivingEntity)entity, difficulty));
        if (EnabledFeatures.mobHpIncreaseEnabled()) {
            double healthBoost = difficulty;
            double healthMultiplier = isHostile ? SHMobs.healthHostileMultiplier() : SHMobs.healthPassiveMultiplier();
            healthBoost *= healthMultiplier;
            if (CommonEvents.spawnerSpawns.contains(entity.m_20148_())) {
                healthBoost *= SHMobs.spawnerModifier();
                CommonEvents.spawnerSpawns.remove(entity.m_20148_());
            }
            MobHealthMode mode = SHMobs.getHealthMode();
            ModifierHandler.setMaxHealth((LivingEntity)entity, mode.getModifierHealth(healthBoost, entity.m_21051_(Attributes.f_22276_).m_22115_()), mode.getOp());
        }
        if (EnabledFeatures.mobDamageIncreaseEnabled()) {
            ResourceLocation loc;
            float diffIncrease = difficulty * ScalingHealth.RANDOM.nextFloat();
            double damageBoost = (double)diffIncrease * SHMobs.damageBoostScale();
            double max = SHMobs.maxDamageBoost();
            if (max > 0.0) {
                damageBoost = Mth.m_14008_((double)damageBoost, (double)0.0, (double)max);
            }
            if ((loc = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())) != null && !SHDifficulty.getDamageBlacklistedMods().contains(loc.m_135827_())) {
                ModifierHandler.addAttackDamage((LivingEntity)entity, damageBoost, AttributeModifier.Operation.ADDITION);
            }
        }
    }
}

