/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.silentchaos512.lib.util.EntityHelper;

public final class ModifierHandler {
    private static final UUID MODIFIER_ID_HEALTH = UUID.fromString("c0bef565-35f6-4dc5-bb4c-3644c382e6ce");
    private static final UUID MODIFIER_ID_DAMAGE = UUID.fromString("d3560b15-c459-451c-86a8-0247015ae899");
    private static final String MODIFIER_NAME_HEALTH = "ScalingHealth.HealthModifier";
    private static final String MODIFIER_NAME_DAMAGE = "ScalingHealth.DamageModifier";

    private ModifierHandler() {
        throw new IllegalAccessError("Utility class");
    }

    public static void setModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name, double amount, AttributeModifier.Operation op) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        AttributeModifier mod = instance.m_22111_(uuid);
        if (mod != null) {
            instance.m_22130_(mod);
        }
        instance.m_22125_(new AttributeModifier(uuid, name, amount, op));
    }

    public static void setMaxHealth(LivingEntity entity, double amount, AttributeModifier.Operation op) {
        double oldMax = entity.m_21233_();
        ModifierHandler.setModifier(entity, Attributes.f_22276_, MODIFIER_ID_HEALTH, MODIFIER_NAME_HEALTH, amount, op);
        double newMax = entity.m_21233_();
        if (newMax > oldMax) {
            float healAmount = (float)(newMax - oldMax);
            EntityHelper.heal((LivingEntity)entity, (float)healAmount, (boolean)false);
        } else if ((double)entity.m_21223_() > newMax) {
            entity.m_21153_((float)newMax);
        }
    }

    public static void addAttackDamage(LivingEntity entity, double amount, AttributeModifier.Operation op) {
        ModifierHandler.setModifier(entity, Attributes.f_22281_, MODIFIER_ID_DAMAGE, MODIFIER_NAME_DAMAGE, amount, op);
    }
}

