/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils.config;

import java.util.List;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.scalinghealth.resources.mechanics.MobMechanics;
import net.silentchaos512.scalinghealth.resources.mechanics.SHMechanics;
import net.silentchaos512.scalinghealth.resources.tags.EntityTags;
import net.silentchaos512.scalinghealth.utils.config.EnabledFeatures;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.mode.MobHealthMode;
import net.silentchaos512.scalinghealth.utils.serialization.DifficultyMobEffect;

public final class SHMobs {
    private SHMobs() {
        throw new IllegalAccessError("Utility class");
    }

    private static MobMechanics getMechanics() {
        return SHMechanics.getMechanics().mobMechanics();
    }

    public static boolean allowsDifficultyChanges(Mob entity) {
        return !entity.m_6095_().m_204039_(EntityTags.DIFFICULTY_EXEMPT);
    }

    public static double blightChance() {
        return SHMobs.getMechanics().blight().blightChance();
    }

    public static boolean canBecomeBlight(Mob entity) {
        return EnabledFeatures.blightsEnabled() && !entity.m_6095_().m_204039_(EntityTags.BLIGHT_EXEMPT);
    }

    public static boolean isBlight(Mob entity) {
        return SHDifficulty.affected((ICapabilityProvider)entity).isBlight();
    }

    public static double getBlightDifficultyMultiplier() {
        return SHMobs.getMechanics().blight().blightDifficultyModifier();
    }

    public static boolean notifyBlightDeath() {
        return SHMobs.getMechanics().blight().notifyBlightDeath();
    }

    public static double healthPassiveMultiplier() {
        return SHMobs.getMechanics().generic().passiveMultiplier();
    }

    public static double healthHostileMultiplier() {
        return SHMobs.getMechanics().generic().hostileMultiplier();
    }

    public static List<DifficultyMobEffect> getMobEffects() {
        return SHMobs.getMechanics().mobEffects();
    }

    public static double passivePotionChance() {
        return SHMobs.getMechanics().generic().peacefulPotionChance();
    }

    public static double hostilePotionChance() {
        return SHMobs.getMechanics().generic().hostilePotionChance();
    }

    public static MobHealthMode getHealthMode() {
        return SHMobs.getMechanics().mode();
    }

    public static double spawnerModifier() {
        return SHMobs.getMechanics().generic().spawnerModifier();
    }

    public static double xpBoost() {
        return SHMobs.getMechanics().generic().xpBoost();
    }

    public static double xpBlightBoost() {
        return SHMobs.getMechanics().blight().blightXpBoost();
    }

    public static double damageBoostScale() {
        return SHMobs.getMechanics().generic().damageBoostScale();
    }

    public static double maxDamageBoost() {
        return SHMobs.getMechanics().generic().maxDamageBoost();
    }
}

