/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils.mode;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.silentchaos512.scalinghealth.utils.serialization.SerializationUtils;

public class MobHealthMode {
    public static final Codec<MobHealthMode> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SerializationUtils.ATTRIBUTE_OPERATION_CODEC.fieldOf("operation").forGetter(m -> m.op), (App)Codec.DOUBLE.optionalFieldOf("scaling_reduction", (Object)0.0).forGetter(m -> m.scaleReduction)).apply((Applicative)inst, MobHealthMode::new));
    private final AttributeModifier.Operation op;
    private final double scaleReduction;

    public MobHealthMode(AttributeModifier.Operation op, double scaleReduction) {
        this.op = op;
        this.scaleReduction = scaleReduction;
    }

    public double getModifierHealth(double healthBoost, double baseMaxHp) {
        if (this.op == AttributeModifier.Operation.ADDITION) {
            return healthBoost;
        }
        double healthScale = this.scaleReduction * Math.max(0.0, baseMaxHp - 20.0);
        return healthBoost / (20.0 + healthScale);
    }

    public AttributeModifier.Operation getOp() {
        return this.op;
    }
}

