/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils.serialization;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.scalinghealth.utils.EntityGroup;
import net.silentchaos512.scalinghealth.utils.serialization.SerializationUtils;
import net.silentchaos512.utils.MathUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public record DifficultyMobEffect(MobEffect effect, int level, int minDifficulty, double durationMinutes) {
    private static final Marker MARKER = MarkerManager.getMarker((String)"DifficultyMobEffects");
    public static final Codec<DifficultyMobEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.comapFlatMap(rl -> ForgeRegistries.MOB_EFFECTS.containsKey(rl) ? DataResult.success((Object)((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(rl))) : DataResult.error(() -> "No potion named:" + rl.toString()), arg_0 -> ((IForgeRegistry)ForgeRegistries.MOB_EFFECTS).getKey(arg_0)).fieldOf("effect").forGetter(e -> e.effect), (App)SerializationUtils.positiveInt().fieldOf("level").forGetter(e -> e.level), (App)SerializationUtils.positiveInt().fieldOf("minDifficulty").forGetter(e -> e.minDifficulty), (App)SerializationUtils.positiveDouble().fieldOf("durationInMinutes").forGetter(e -> e.durationMinutes)).apply((Applicative)inst, DifficultyMobEffect::new));

    public void apply(LivingEntity e, double difficulty) {
        if (difficulty >= (double)this.minDifficulty) {
            e.m_7292_(new MobEffectInstance(this.effect, (int)(this.durationMinutes * 60.0 * 20.0), this.level - 1));
            if (ScalingHealth.LOGGER.isDebugEnabled() && SHConfig.SERVER.debugMobPotionEffects.get().booleanValue()) {
                ScalingHealth.LOGGER.debug(MARKER, "Applied effect {}, level {} for {}min to {} ({})", (Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)this.effect), (Object)this.level, (Object)this.durationMinutes, (Object)e.m_6302_(), (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_()));
            }
        }
    }

    public void tryApply(LivingEntity e, double difficulty) {
        if (MathUtils.tryPercentage((double)EntityGroup.from(e).getPotionChance())) {
            this.apply(e, difficulty);
        }
    }
}

