/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.thatpreston.mermod.MermodClient;
import io.github.thatpreston.mermod.client.render.TailStyle;
import io.github.thatpreston.mermod.client.render.model.TailModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TailRenderLayer<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final List<TailModel> models = new ArrayList<TailModel>();

    public TailRenderLayer(RenderLayerParent<T, M> parent, EntityModelSet set) {
        super(parent);
        for (ModelLayerLocation layer : MermodClient.TAIL_MODEL_LAYERS) {
            this.models.add(new TailModel(set.m_171103_(layer)));
        }
    }

    public void render(PoseStack stack, MultiBufferSource source, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float yaw, float pitch) {
        TailStyle style = MermodClient.getRenderedTailStyle(entity);
        if (style != null) {
            TailModel model = this.getModel(style.model());
            stack.m_85836_();
            VertexConsumer consumer = ItemRenderer.m_115222_((MultiBufferSource)source, (RenderType)RenderType.m_110470_((ResourceLocation)style.texture()), (boolean)false, (boolean)style.hasGlint());
            model.copyFrom((HumanoidModel)this.m_117386_());
            model.setupAnim((Player)entity, limbSwing, limbSwingAmount, age, yaw, pitch);
            model.render(stack, consumer, light, OverlayTexture.f_118083_, style);
            stack.m_85849_();
        }
    }

    private TailModel getModel(int model) {
        if (model >= 0 && model < this.models.size()) {
            return this.models.get(model);
        }
        return this.models.get(0);
    }
}

