/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.client.render;

import io.github.thatpreston.mermod.Mermod;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record TailStyle(ResourceLocation texture, int model, int tailColor, boolean hasBra, int braColor, boolean hasGradient, int gradientColor, boolean hasGlint, boolean permanent) {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("mermod", "textures/tail/tail.png");
    private static final HashMap<String, ResourceLocation> TAIL_LOCATION_CACHE = new HashMap();

    public static TailStyle fromNecklace(ItemStack necklace) {
        CompoundTag tag = necklace.m_41698_("necklace_modifiers");
        int model = tag.m_128451_("model");
        int tailColor = Mermod.getItemColor(necklace);
        boolean hasBra = tag.m_128441_("bra");
        int braColor = hasBra ? tag.m_128451_("bra_color") : 0xFFFFFF;
        boolean hasGradient = tag.m_128441_("gradient");
        int gradientColor = tag.m_128451_("gradient_color");
        String textureName = tag.m_128461_("texture");
        ResourceLocation texture = textureName.isEmpty() ? DEFAULT_TEXTURE : TailStyle.getTailLocation(textureName, tailColor != 0xFFFFFF || braColor != 0xFFFFFF || hasGradient);
        return new TailStyle(texture, model, tailColor, hasBra, braColor, hasGradient, gradientColor, tag.m_128441_("glint"), tag.m_128441_("permanent"));
    }

    private static ResourceLocation getTailLocation(String name, boolean colorable) {
        String string = "textures/tail/" + name + (colorable ? "_colorable" : "") + ".png";
        return TAIL_LOCATION_CACHE.computeIfAbsent(string, path -> new ResourceLocation("mermod", path));
    }
}

