/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.item;

import dev.architectury.extensions.ItemExtension;
import io.github.thatpreston.mermod.Mermod;
import io.github.thatpreston.mermod.item.modifier.DyeableNecklaceModifierItem;
import io.github.thatpreston.mermod.item.modifier.NecklaceModifier;
import io.github.thatpreston.mermod.item.modifier.NecklaceModifierItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SeaNecklaceItem
extends Item
implements DyeableLeatherItem,
ItemExtension {
    public SeaNecklaceItem() {
        super(new Item.Properties().arch$tab(CreativeModeTabs.f_256869_).m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        ItemStack necklace = player.m_21120_(hand);
        if (player.m_6047_() && !(stack = SeaNecklaceItem.removeModifier(necklace)).m_41619_()) {
            if (!player.m_36356_(stack)) {
                player.m_36176_(stack, false);
            }
            return InteractionResultHolder.m_19092_((Object)necklace, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)necklace);
    }

    public EquipmentSlot getCustomEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public void tickArmor(ItemStack stack, Player player) {
        Mermod.addEffects((LivingEntity)player);
    }

    public static void addModifiers(ItemStack necklace, List<ItemStack> modifiers) {
        for (ItemStack stack : modifiers) {
            NecklaceModifierItem item = (NecklaceModifierItem)stack.m_41720_();
            item.addModifier(necklace, stack);
        }
    }

    public static boolean canAddModifiers(ItemStack necklace, List<ItemStack> modifiers) {
        ArrayList<String> addedTypes = new ArrayList<String>();
        for (ItemStack stack : modifiers) {
            NecklaceModifierItem item = (NecklaceModifierItem)stack.m_41720_();
            String type = item.getModifier().getType();
            if (addedTypes.contains(type) || !item.canAddModifier(necklace)) {
                return false;
            }
            addedTypes.add(type);
        }
        return true;
    }

    public static ItemStack removeModifier(ItemStack necklace) {
        for (NecklaceModifierItem item : NecklaceModifierItem.MODIFIERS) {
            ItemStack stack = item.removeModifier(necklace);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack necklace, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        CompoundTag tag = necklace.m_41698_("necklace_modifiers");
        int count = 0;
        for (NecklaceModifierItem item : NecklaceModifierItem.MODIFIERS) {
            NecklaceModifier modifier = item.getModifier();
            if (!modifier.isAdded(tag)) continue;
            int color = item instanceof DyeableNecklaceModifierItem ? tag.m_128451_(modifier.getType() + "_color") : modifier.getTooltipColor();
            list.add((Component)Component.m_237115_((String)("item.mermod." + modifier.getId() + "_modifier")).m_130948_(Style.f_131099_.m_178520_(color)));
            ++count;
        }
        if (count > 0) {
            list.add((Component)Component.m_237115_((String)"item.mermod.sea_necklace.tooltip").m_130940_(ChatFormatting.GRAY));
        }
    }
}

