/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.entity.GhastTrapBlockEntity;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;

public class GhastTrapBlock
extends BaseEntityBlock {
    public static final int ACTIVATE_EVENT = 0;
    public static final int DEACTIVATE_EVENT = 1;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public GhastTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (!((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && this.isInactiveTrapCharged(level, pos) && level.m_276867_(pos)) {
            for (ServerPlayer player : level.m_45976_(ServerPlayer.class, new AABB(pos).m_82400_(6.0))) {
                TFAdvancements.ACTIVATED_GHAST_TRAP.trigger(player);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.m_5594_(null, pos, (SoundEvent)TFSounds.JET_START.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_7696_(pos, (Block)this, 0, 0);
        }
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int event, int payload) {
        BlockEntity te = level.m_7702_(pos);
        return te != null && te.m_7531_(event, payload);
    }

    private boolean isInactiveTrapCharged(Level level, BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        return tileEntity instanceof GhastTrapBlockEntity && ((GhastTrapBlockEntity)tileEntity).isCharged();
    }

    public void sparkle(Level level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.m_123341_() + random.m_188501_();
            double d2 = (float)pos.m_123342_() + random.m_188501_();
            double d3 = (float)pos.m_123343_() + random.m_188501_();
            if (i == 0 && !level.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)level, pos)) {
                d2 = (double)pos.m_123342_() + d0 + 1.0;
            }
            if (i == 1 && !level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos)) {
                d2 = (double)pos.m_123342_() - d0;
            }
            if (i == 2 && !level.m_8055_(pos.m_122019_()).m_60804_((BlockGetter)level, pos)) {
                d3 = (double)pos.m_123343_() + d0 + 1.0;
            }
            if (i == 3 && !level.m_8055_(pos.m_122012_()).m_60804_((BlockGetter)level, pos)) {
                d3 = (double)pos.m_123343_() - d0;
            }
            if (i == 4 && !level.m_8055_(pos.m_122029_()).m_60804_((BlockGetter)level, pos)) {
                d1 = (double)pos.m_123341_() + d0 + 1.0;
            }
            if (i == 5 && !level.m_8055_(pos.m_122024_()).m_60804_((BlockGetter)level, pos)) {
                d1 = (double)pos.m_123341_() - d0;
            }
            if (!(d1 < (double)pos.m_123341_() || d1 > (double)(pos.m_123341_() + 1) || d2 < 0.0 || d2 > (double)(pos.m_123342_() + 1) || d3 < (double)pos.m_123343_()) && !(d3 > (double)(pos.m_123343_() + 1))) continue;
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GhastTrapBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return GhastTrapBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.GHAST_TRAP.get()), GhastTrapBlockEntity::tick);
    }
}

