/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.network.packet;

import com.blackgear.platform.Platform;
import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketContext;
import com.blackgear.platform.core.network.base.PacketHandler;
import com.blackgear.platform.core.util.config.ConfigLoader;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record ConfigSyncPacket(String name, byte[] data) implements Packet<ConfigSyncPacket>
{
    public static final ResourceLocation ID = Platform.resource("config_sync");
    public static final Handler HANDLER = new Handler();

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public PacketHandler<ConfigSyncPacket> getHandler() {
        return HANDLER;
    }

    public static final class Handler
    implements PacketHandler<ConfigSyncPacket> {
        @Override
        public void encode(ConfigSyncPacket message, FriendlyByteBuf buf) {
            buf.m_130070_(message.name);
            buf.m_130087_(message.data);
        }

        @Override
        public ConfigSyncPacket decode(FriendlyByteBuf buf) {
            return new ConfigSyncPacket(buf.m_130277_(), buf.m_130052_());
        }

        @Override
        public PacketContext handle(ConfigSyncPacket message) {
            return (player, level) -> {
                ModConfig config = ConfigTracker.INSTANCE.fileMap().get(message.name);
                if (config != null) {
                    config.acceptSyncedConfig(message.data);
                } else {
                    ConfigLoader.LOGGER.error("Received config data for unknown config: {}", (Object)message.name);
                }
            };
        }
    }
}

