/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModCreativeModeTabs;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.core.ModRecipes;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.datagen.ModBlockStateProvider;
import me.desht.modularrouters.datagen.ModBlockTagsProvider;
import me.desht.modularrouters.datagen.ModEntityTypeTagsProvider;
import me.desht.modularrouters.datagen.ModItemModelProvider;
import me.desht.modularrouters.datagen.ModItemTagsProvider;
import me.desht.modularrouters.datagen.ModLootTableProvider;
import me.desht.modularrouters.datagen.ModRecipeProvider;
import me.desht.modularrouters.integration.IntegrationHandler;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.ModNameCache;
import me.desht.modularrouters.util.WildcardedRLMatcher;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="modularrouters")
public class ModularRouters {
    public static final String MODID = "modularrouters";
    public static final String MODNAME = "Modular Routers";
    public static final Logger LOGGER = LogManager.getLogger((String)"Modular Routers");
    private static WildcardedRLMatcher dimensionBlacklist;

    public ModularRouters() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHolder.init();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::initEarly);
        modBus.addListener(this::commonSetup);
        ModBlocks.BLOCKS.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modBus);
        ModMenuTypes.MENUS.register(modBus);
        ModSounds.SOUNDS.register(modBus);
        ModRecipes.RECIPES.register(modBus);
        ModCreativeModeTabs.TABS.register(modBus);
    }

    public static WildcardedRLMatcher getDimensionBlacklist() {
        if (dimensionBlacklist == null) {
            dimensionBlacklist = new WildcardedRLMatcher((Collection)ConfigHolder.common.module.dimensionBlacklist.get());
        }
        return dimensionBlacklist;
    }

    public static void clearDimensionBlacklist() {
        dimensionBlacklist = null;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Modular Routers is loading!");
        PacketHandler.setupNetwork();
        event.enqueueWork(() -> {
            IntegrationHandler.registerAll();
            XPCollection.detectXPTypes();
            ModNameCache.init();
        });
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class DataGenerators {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            CompletableFuture lookupProvider = event.getLookupProvider();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            if (event.includeServer()) {
                generator.addProvider(event.includeClient(), (DataProvider)new ModRecipeProvider(generator));
                ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(generator, lookupProvider, existingFileHelper);
                generator.addProvider(event.includeClient(), (DataProvider)blockTagsProvider);
                generator.addProvider(event.includeClient(), (DataProvider)new ModItemTagsProvider(generator, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
                generator.addProvider(event.includeClient(), (DataProvider)new ModLootTableProvider(generator));
                generator.addProvider(event.includeClient(), (DataProvider)new ModEntityTypeTagsProvider(generator, lookupProvider, existingFileHelper));
            }
            if (event.includeClient()) {
                generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(generator, existingFileHelper));
                generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(generator, existingFileHelper));
            }
        }
    }
}

