/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic.owners;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.owners.RedstoneControlCallbacks;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;

public class MultiblockCallbackWrapper<S extends IMultiblockState>
extends CallbackOwner<IMultiblockBE<S>> {
    private final MultiblockRegistration<S> multiblock;
    private final Set<BlockPos> validPositions;

    public MultiblockCallbackWrapper(Callback<S> innerCallback, MultiblockRegistration<S> multiblock, String name, BlockPos ... validPositions) {
        super(IMultiblockBE.class, name);
        this.multiblock = multiblock;
        this.validPositions = Set.of(validPositions);
        this.addAdditional(innerCallback, this.stateGetter());
        for (MultiblockRegistration.ExtraComponent<S, ?> component : multiblock.extraComponents()) {
            RedstoneControl rsControl;
            if (!(component.makeWrapper() instanceof RedstoneControl) || !(rsControl = (RedstoneControl)component.makeWrapper()).allowComputerControl()) continue;
            this.addAdditional(new RedstoneControlCallbacks(), this.stateGetter().andThen(rsControl::wrapState));
        }
    }

    private Function<IMultiblockBE<S>, S> stateGetter() {
        return imbe -> imbe.getHelper().getState();
    }

    @Override
    public boolean canAttachTo(IMultiblockBE<S> candidate) {
        IMultiblockBEHelper<S> helper = candidate.getHelper();
        if (helper.getMultiblock() != this.multiblock) {
            return false;
        }
        return this.validPositions.contains(helper.getPositionInMB());
    }
}

