/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlock;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin(value="tesseract")
public class TesseractJadePlugin
implements IBlockComponentProvider,
IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)this, TesseractBlock.class);
        registration.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
                tooltip.remove(new ResourceLocation("fe"));
                tooltip.remove(new ResourceLocation("fluid"));
            }

            public ResourceLocation getUid() {
                return new ResourceLocation("tesseract", "remove_default");
            }

            public int getDefaultPriority() {
                return 10000;
            }
        }, TesseractBlock.class);
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("tesseract", "tesseract");
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity entity = accessor.getBlockEntity();
        if (entity instanceof TesseractBlockEntity) {
            TesseractBlockEntity tesseract = (TesseractBlockEntity)entity;
            tooltip.add((Component)TextComponents.translation((String)"tesseract.tesseract.highlight.channels").get());
            tooltip.add(TesseractJadePlugin.formatChannelInfo(EnumChannelType.ITEMS, tesseract.getChannelId(EnumChannelType.ITEMS)));
            tooltip.add(TesseractJadePlugin.formatChannelInfo(EnumChannelType.ENERGY, tesseract.getChannelId(EnumChannelType.ENERGY)));
            tooltip.add(TesseractJadePlugin.formatChannelInfo(EnumChannelType.FLUID, tesseract.getChannelId(EnumChannelType.FLUID)));
            if (tesseract.isBlockedByRedstone()) {
                tooltip.add((Component)TextComponents.translation((String)"tesseract.tesseract.highlight.redstone_blocked").color(ChatFormatting.RED).get());
            }
        }
    }

    private static Component formatChannelInfo(EnumChannelType type, int channelId) {
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, channelId);
        MutableComponent channelType = TextComponents.fromTextComponent((Component)type.getTranslation()).color(ChatFormatting.GOLD).get();
        MutableComponent separator = TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.separator").get();
        MutableComponent channelName = channel == null ? TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.inactive").color(ChatFormatting.DARK_GRAY).italic().get() : TextComponents.string((String)channel.name).get();
        return TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info", (Object[])new Object[]{channelType, separator, channelName}).get();
    }
}

