/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.packets.PacketAddTesseractReferences;
import com.supermartijn642.tesseract.packets.PacketRemoveTesseractReferences;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class TesseractTracker {
    public static final TesseractTracker SERVER = new TesseractTracker();
    public static final TesseractTracker CLIENT = new TesseractTracker();
    private static long referenceIndexCounter = 0L;
    private final HashMap<String, HashMap<BlockPos, TesseractReference>> tesseracts = new HashMap();
    private final Set<TesseractReference> dirtyReferences = new HashSet<TesseractReference>();
    private final Set<TesseractReference> referencesToBeRemoved = new HashSet<TesseractReference>();
    private final Set<TesseractReference> referencesToBeSaved = new HashSet<TesseractReference>();
    private final Set<Long> referencesToBeUnsaved = new HashSet<Long>();

    public static TesseractTracker getInstance(Level level) {
        return level.f_46443_ ? CLIENT : SERVER;
    }

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(TesseractTracker::onTick);
    }

    public TesseractReference add(TesseractBlockEntity self) {
        BlockPos pos;
        String dimension = self.m_58904_().m_46472_().m_135782_().toString();
        TesseractReference reference = this.getReference(dimension, pos = self.m_58899_());
        if (reference != null) {
            return reference;
        }
        if (this == SERVER) {
            reference = new TesseractReference(referenceIndexCounter++, self);
            this.markDirty(reference);
        } else {
            reference = new TesseractReference(0L, self);
        }
        this.tesseracts.computeIfAbsent(dimension, o -> new HashMap()).put(pos, reference);
        return reference;
    }

    public void add(TesseractReference reference) {
        if (this == CLIENT) {
            String dimension = reference.getDimension();
            BlockPos pos = reference.getPos();
            TesseractReference oldReference = this.tesseracts.computeIfAbsent(dimension, o -> new HashMap()).put(pos, reference);
            if (oldReference != null && oldReference != reference && oldReference.canBeAccessed()) {
                oldReference.getTesseract().invalidateReference();
            }
        }
    }

    public TesseractReference getReference(String dimension, BlockPos pos) {
        return this.tesseracts.containsKey(dimension) ? this.tesseracts.get(dimension).get(pos) : null;
    }

    public void remove(Level level, BlockPos pos) {
        String dimension = level.m_46472_().m_135782_().toString();
        this.remove(dimension, pos);
    }

    public void remove(String dimension, BlockPos pos) {
        if (this == SERVER) {
            TesseractReference reference = this.getReference(dimension, pos);
            if (reference != null) {
                this.referencesToBeRemoved.add(reference);
            }
        } else if (this.tesseracts.containsKey(dimension)) {
            this.tesseracts.get(dimension).remove(pos);
        }
    }

    void markDirty(TesseractReference reference) {
        this.dirtyReferences.add(reference);
        this.referencesToBeSaved.add(reference);
    }

    public static void onTick(TickEvent.LevelTickEvent e) {
        if (e.level.f_46443_ || e.phase != TickEvent.Phase.END || e.level.m_46472_() != Level.f_46428_) {
            return;
        }
        if (!TesseractTracker.SERVER.referencesToBeRemoved.isEmpty()) {
            for (TesseractReference reference : TesseractTracker.SERVER.referencesToBeRemoved) {
                reference.delete();
                TesseractTracker.SERVER.tesseracts.get(reference.getDimension()).remove(reference.getPos());
                TesseractTracker.SERVER.dirtyReferences.remove(reference);
                TesseractTracker.SERVER.referencesToBeUnsaved.add(reference.getSaveIndex());
                TesseractTracker.SERVER.referencesToBeSaved.remove(reference);
            }
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketRemoveTesseractReferences(new ArrayList<TesseractReference>(TesseractTracker.SERVER.referencesToBeRemoved)));
            TesseractTracker.SERVER.referencesToBeRemoved.clear();
        }
        if (!TesseractTracker.SERVER.dirtyReferences.isEmpty()) {
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketAddTesseractReferences(new ArrayList<TesseractReference>(TesseractTracker.SERVER.dirtyReferences), false));
            TesseractTracker.SERVER.dirtyReferences.clear();
        }
    }

    public void clear() {
        if (this == SERVER) {
            throw new IllegalStateException("Server references cannot be cleared!");
        }
        this.tesseracts.clear();
    }

    public CompoundTag writeKey(TesseractReference reference) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("dimension", reference.getDimension());
        tag.m_128405_("posx", reference.getPos().m_123341_());
        tag.m_128405_("posy", reference.getPos().m_123342_());
        tag.m_128405_("posz", reference.getPos().m_123343_());
        return tag;
    }

    public TesseractReference fromKey(CompoundTag key) {
        String dimension = key.m_128461_("dimension");
        BlockPos pos = new BlockPos(key.m_128451_("posx"), key.m_128451_("posy"), key.m_128451_("posz"));
        return this.getReference(dimension, pos);
    }

    public static void saveReferences(Path saveDirectory) {
        Path file;
        Path directory = saveDirectory.resolve("tesseract/tracking");
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            Tesseract.LOGGER.error("Failed to create tesseract reference save directory!", (Throwable)e);
            return;
        }
        for (TesseractReference reference : TesseractTracker.SERVER.referencesToBeSaved) {
            file = directory.resolve("tesseract" + reference.getSaveIndex() + ".nbt");
            try (DataOutputStream output = new DataOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
                NbtIo.m_128941_((CompoundTag)reference.write(), (DataOutput)output);
            }
            catch (IOException e) {
                Tesseract.LOGGER.error("Failed to save tesseract reference file '" + file + "'!", (Throwable)e);
            }
        }
        for (Long index : TesseractTracker.SERVER.referencesToBeUnsaved) {
            file = directory.resolve("tesseract" + index + ".nbt");
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                Tesseract.LOGGER.error("Failed to remove tesseract reference file '" + file + "'!", (Throwable)e);
            }
        }
        TesseractTracker.SERVER.referencesToBeSaved.clear();
        TesseractTracker.SERVER.referencesToBeUnsaved.clear();
    }

    public static void loadReferences(Path saveDirectory) {
        TesseractTracker.SERVER.tesseracts.clear();
        TesseractTracker.SERVER.dirtyReferences.clear();
        TesseractTracker.SERVER.referencesToBeRemoved.clear();
        TesseractTracker.SERVER.referencesToBeSaved.clear();
        TesseractTracker.SERVER.referencesToBeUnsaved.clear();
        referenceIndexCounter = 0L;
        Path directory = saveDirectory.resolve("tesseract/tracking");
        if (Files.exists(directory, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(directory);){
                files.forEach(file -> {
                    String fileName;
                    if (Files.isRegularFile(file, new LinkOption[0]) && (fileName = file.getFileName().toString()).startsWith("tesseract") && fileName.endsWith(".nbt")) {
                        try {
                            CompoundTag tag;
                            long index = Long.parseLong(file.getFileName().toString().substring("tesseract".length(), file.getFileName().toString().length() - ".nbt".length()));
                            if (index >= referenceIndexCounter) {
                                referenceIndexCounter = index + 1L;
                            }
                            try (DataInputStream input = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                                tag = NbtIo.m_128928_((DataInput)input);
                            }
                            TesseractReference reference = new TesseractReference(index, tag, false);
                            TesseractTracker.SERVER.tesseracts.putIfAbsent(reference.getDimension(), new HashMap());
                            TesseractTracker.SERVER.tesseracts.get(reference.getDimension()).put(reference.getPos(), reference);
                        }
                        catch (IOException exception) {
                            Tesseract.LOGGER.error("Failed to read tesseract data from file '~/tesseract/tracking/" + file.getFileName() + "':", (Throwable)exception);
                        }
                    }
                });
            }
            catch (IOException e) {
                Tesseract.LOGGER.error("Failed to load tesseract references!", (Throwable)e);
            }
        }
        System.out.println("Loaded " + TesseractTracker.SERVER.tesseracts.values().stream().map(Map::values).mapToLong(Collection::size).sum() + " tesseract references!");
    }

    public static void sendReferences(Player player) {
        Collection references = TesseractTracker.SERVER.tesseracts.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
        Tesseract.CHANNEL.sendToPlayer(player, (BasePacket)new PacketAddTesseractReferences(references, true));
    }
}

