/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LockButton
extends AbstractButtonWidget {
    private boolean locked;
    private boolean active = true;

    public LockButton(int x, int y) {
        super(x, y, 20, 20, null);
    }

    public void onPress() {
        super.onPress();
        this.locked = !this.locked;
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"gui.narrate.button", (Object[])new Object[]{TextComponents.translation((String)"narrator.button.difficulty_lock").get()}).string(". ").translation(this.isLocked() ? "narrator.button.difficulty_lock.locked" : "narrator.button.difficulty_lock.unlocked").get();
    }

    public void render(WidgetRenderContext context, int x, int y) {
        ScreenUtils.bindTexture((ResourceLocation)Button.f_93617_);
        Icon icon = !this.active ? (this.locked ? Icon.LOCKED_DISABLED : Icon.UNLOCKED_DISABLED) : (this.isFocused() ? (this.locked ? Icon.LOCKED_HOVER : Icon.UNLOCKED_HOVER) : (this.locked ? Icon.LOCKED : Icon.UNLOCKED));
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)((float)icon.getX() / 256.0f), (float)((float)icon.getY() / 256.0f), (float)0.078125f, (float)0.078125f);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean lockedIn) {
        this.locked = lockedIn;
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        tooltips.accept((Component)TextComponents.translation((String)("gui.tesseract.channel." + (this.locked ? "private" : "public"))).get());
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Icon {
        LOCKED(0, 146),
        LOCKED_HOVER(0, 166),
        LOCKED_DISABLED(0, 186),
        UNLOCKED(20, 146),
        UNLOCKED_HOVER(20, 166),
        UNLOCKED_DISABLED(20, 186);

        private final int x;
        private final int y;

        private Icon(int xIn, int yIn) {
            this.x = xIn;
            this.y = yIn;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

