/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.compat.irons_spellbooks;

import de.cadentem.pufferfish_unofficial_additions.PUA;
import de.cadentem.pufferfish_unofficial_additions.compat.irons_spellbooks.ISPrototypes;
import de.cadentem.pufferfish_unofficial_additions.prototypes.CustomPrototypes;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyCalculation;

public class SpellCastingExperienceSource
implements ExperienceSource {
    private static final ResourceLocation ID = PUA.location("spell_casting");
    private static final Prototype<Data> PROTOTYPE = Prototype.create((ResourceLocation)ID);
    private final Calculation<Data> calculation;

    private SpellCastingExperienceSource(Calculation<Data> calculation) {
        this.calculation = calculation;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource((ResourceLocation)ID, SpellCastingExperienceSource::parse);
    }

    private static Result<SpellCastingExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(rootElement -> LegacyCalculation.parse((JsonElement)rootElement, PROTOTYPE, (ConfigContext)context).mapSuccess(SpellCastingExperienceSource::new));
    }

    public int getValue(ServerPlayer caster, SchoolType school, String spellId, int level, CastSource castSource) {
        int manaCost;
        AbstractSpell spell;
        ItemStack mainHand = caster.m_21205_();
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)caster);
        if (spellbook == null) {
            spellbook = ItemStack.f_41583_;
        }
        if ((spell = SpellRegistry.getSpell((String)spellId)) == null) {
            PUA.LOG.warn("Spell [{}] could not be found", (Object)spellId);
            return 0;
        }
        SpellRarity rarity = spell.getRarity(level);
        int minLevelRarity = spell.getMinLevelForRarity(rarity);
        int n = manaCost = castSource.consumesMana() ? spell.getManaCost(level) : 0;
        int manaCostPerSecond = castSource.consumesMana() ? (spell.getCastType() == CastType.CONTINUOUS ? manaCost * 2 : 0) : 0;
        int castDurationTicks = spell.getCastType() == CastType.CONTINUOUS ? spell.getEffectiveCastTime(level, (LivingEntity)caster) : 0;
        double castDuration = (double)castDurationTicks / 20.0;
        double castChargeTime = spell.getCastType() == CastType.LONG ? (double)spell.getEffectiveCastTime(level, (LivingEntity)caster) / 20.0 : 0.0;
        double cooldown = (double)MagicManager.getEffectiveSpellCooldown((AbstractSpell)spell, (Player)caster, (CastSource)castSource) / 20.0;
        int expectedTicks = spell.getCastType() == CastType.CONTINUOUS ? castDurationTicks / 10 : 1;
        Data data = new Data(caster, mainHand, spellbook, school, spell, rarity, level, minLevelRarity, manaCost, manaCostPerSecond, castDuration, castChargeTime, cooldown, expectedTicks);
        PUA.LOG.debug("Spell experience source data: [{}]", (Object)data);
        return (int)Math.round(this.calculation.evaluate((Object)data));
    }

    public void dispose(ExperienceSourceDisposeContext experienceSourceDisposeContext) {
    }

    static {
        PROTOTYPE.registerOperation(PUA.location("player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::caster));
        PROTOTYPE.registerOperation(PUA.location("main_hand"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::mainHand));
        PROTOTYPE.registerOperation(PUA.location("spellbook"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::spellbook));
        PROTOTYPE.registerOperation(PUA.location("school"), ISPrototypes.SCHOOL, OperationFactory.create(Data::school));
        PROTOTYPE.registerOperation(PUA.location("spell"), ISPrototypes.SPELL, OperationFactory.create(Data::spell));
        PROTOTYPE.registerOperation(PUA.location("level"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::level));
        PROTOTYPE.registerOperation(PUA.location("min_level_rarity"), BuiltinPrototypes.NUMBER, OperationFactory.create(data -> data.spell.getMinLevelForRarity(data.rarity)));
        PROTOTYPE.registerOperation(PUA.location("rarity_name"), CustomPrototypes.STRING, OperationFactory.create(data -> data.rarity.name()));
        PROTOTYPE.registerOperation(PUA.location("rarity"), BuiltinPrototypes.NUMBER, OperationFactory.create(data -> data.rarity.ordinal()));
        PROTOTYPE.registerOperation(PUA.location("mana_cost"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::manaCost));
        PROTOTYPE.registerOperation(PUA.location("mana_cost_per_second"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::manaCostPerSecond));
        PROTOTYPE.registerOperation(PUA.location("cast_duration"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::castDuration));
        PROTOTYPE.registerOperation(PUA.location("cast_charge_time"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::castChargeTime));
        PROTOTYPE.registerOperation(PUA.location("cooldown"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::cooldown));
        PROTOTYPE.registerOperation(PUA.location("expected_ticks"), BuiltinPrototypes.NUMBER, OperationFactory.create(Data::expectedTicks));
    }

    private record Data(ServerPlayer caster, ItemStack mainHand, ItemStack spellbook, SchoolType school, AbstractSpell spell, SpellRarity rarity, double level, double minLevelRarity, double manaCost, double manaCostPerSecond, double castDuration, double castChargeTime, double cooldown, double expectedTicks) {
        @Override
        public String toString() {
            return "Data{caster=" + this.caster + ", mainHand=" + this.mainHand + ", spellbook=" + this.spellbook + ", school=" + this.school.getId() + ", spell=" + this.spell.getSpellResource() + ", rarity=" + this.rarity + ", level=" + this.level + ", minLevelRarity=" + this.minLevelRarity + ", manaCost=" + this.manaCost + ", manaCostPerSecond=" + this.manaCostPerSecond + ", castDuration=" + this.castDuration + ", castChargeTime=" + this.castChargeTime + ", cooldown=" + this.cooldown + ", expectedTicks=" + this.expectedTicks + "}";
        }
    }
}

