/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.events;

import de.cadentem.pufferfish_unofficial_additions.experience.FishingExperienceSource;
import de.cadentem.pufferfish_unofficial_additions.rewards.EffectReward;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.puffish.skillsmod.api.SkillsAPI;

@Mod.EventBusSubscriber
public class ForgeEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void grantFishingExperience(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (event.getDrops().isEmpty()) {
                SkillsAPI.updateExperienceSources((ServerPlayer)serverPlayer, FishingExperienceSource.class, source -> source.getValue(serverPlayer, serverPlayer.m_21205_(), ItemStack.f_41583_));
            } else {
                event.getDrops().forEach(drop -> SkillsAPI.updateExperienceSources((ServerPlayer)serverPlayer, FishingExperienceSource.class, source -> source.getValue(serverPlayer, serverPlayer.m_21205_(), (ItemStack)drop)));
            }
        }
    }

    @SubscribeEvent
    public static void immuneEffects(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            MobEffect effect = event.getEffectInstance().m_19544_();
            int amplifier = event.getEffectInstance().m_19564_();
            if (EffectReward.isImmune(player.m_20148_(), effect, amplifier)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void retainEffects(MobEffectEvent.Remove event) {
        MobEffectInstance instance = event.getEffectInstance();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (instance != null && instance.m_267577_()) {
                MobEffect effect = instance.m_19544_();
                int amplifier = instance.m_19564_();
                if (EffectReward.shouldRemove(player.m_20148_(), effect, amplifier)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void retainEffects(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            EffectReward.applyEffects(player);
        }
    }

    @SubscribeEvent
    public static void clearData(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EffectReward.clearData(player2.m_20148_());
        }
    }
}

