/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.experience;

import de.cadentem.pufferfish_unofficial_additions.PUA;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyCalculation;

public class HarvestExperienceSource
implements ExperienceSource {
    private static final ResourceLocation ID = PUA.location("harvest_crops");
    private static final Prototype<Data> PROTOTYPE = Prototype.create((ResourceLocation)ID);
    private final Calculation<Data> calculation;

    private HarvestExperienceSource(Calculation<Data> calculation) {
        this.calculation = calculation;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource((ResourceLocation)ID, HarvestExperienceSource::parse);
    }

    private static Result<HarvestExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(rootElement -> LegacyCalculation.parse((JsonElement)rootElement, PROTOTYPE, (ConfigContext)context).mapSuccess(HarvestExperienceSource::new));
    }

    public int getValue(ServerPlayer player, BlockState state, ItemStack tool, List<ItemStack> generatedLoot) {
        return (int)this.calculation.evaluate((Object)new Data(player, state, tool, generatedLoot));
    }

    public void dispose(ExperienceSourceDisposeContext experienceSourceDisposeContext) {
    }

    static {
        PROTOTYPE.registerOperation(PUA.location("player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(PUA.location("block"), BuiltinPrototypes.BLOCK_STATE, OperationFactory.create(Data::state));
        PROTOTYPE.registerOperation(PUA.location("tool"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::tool));
        PROTOTYPE.registerOperation(PUA.location("dropped_seeds"), BuiltinPrototypes.NUMBER, OperationFactory.create(data -> data.loot.stream().filter(item -> item.m_204117_(Tags.Items.SEEDS)).mapToInt(ItemStack::m_41613_).sum()));
        PROTOTYPE.registerOperation(PUA.location("dropped_crops"), BuiltinPrototypes.NUMBER, OperationFactory.create(data -> data.loot.stream().filter(item -> item.m_204117_(Tags.Items.CROPS)).mapToInt(ItemStack::m_41613_).sum()));
    }

    private record Data(ServerPlayer player, BlockState state, ItemStack tool, List<ItemStack> loot) {
    }
}

